% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aop_graph_analysis.R
\name{convert_aop_to_graph}
\alias{convert_aop_to_graph}
\title{Convert AOP to Graph}
\usage{
convert_aop_to_graph(aop)
}
\arguments{
\item{aop}{an object of class \code{aop_cytoscape}.}
}
\value{
aop_graph a \code{graphNEL} object representation of the AOP
}
\description{
Converts an AOP (encoded as \code{aop_cytoscape} object) to a
\code{graphNEL} object.
}
\details{
This function converts an aop_cytoscape object to a \code{graphNEL} object.
This allows us to perform graph-based analyses of the AOP.
}
\examples{
library(graph)
steatosis_json_file <- system.file("extdata", "steatosis_aop_json.cyjs",
package = "aop")
steatosis_aop <- convert_cytoscape_to_aop(steatosis_json_file)
steatosis_aop_graph <- convert_aop_to_graph(steatosis_aop)
plot(steatosis_aop_graph)
}

