% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/aoristic.all.graph.R
\name{aoristic.all.graph}
\alias{aoristic.all.graph}
\title{Creating a data frame for an aoristic graph using all data}
\usage{
aoristic.all.graph(data)
}
\arguments{
\item{data}{data.frame created by aoristic.df}
}
\value{
data data.frame with two columns (hour, freq) used to create an
  aoristic graph for the entire study area
}
\description{
Creating a data frame for an aoristic graph using all data
}
\examples{
\donttest{
data(aoristic)
data <- aoristic.df(data=arlington,
         DateTimeFrom="DateTimeFrom", DateTimeTo="DateTimeTo")
graph <- aoristic.all.graph(data=data)
ggplot(graph, aes(x=hour, y=freq)) +
   geom_bar(stat="identity") +
   ggtitle("Aoristic Graph for the Entire Study Area")

# with probability labels
graph$prob <- paste(round(graph$freq / sum(graph$freq) * 100, 1), "\%", sep="")
ggplot(graph, aes(x=hour, y=freq)) +
   geom_bar(stat="identity") +
   ggtitle("Aoristic Graph for the Entire Study Area") +
   geom_text(aes(y=freq, label=prob), vjust=1.5, colour="white", size=4)

}
}

