\name{ape-package}
\alias{ape-package}
\alias{ape}
\docType{package}
\title{
Analyses of Phylogenetics and Evolution
}
\description{
  \pkg{ape} provides functions for reading and manipulating phylogenetic
  trees and DNA sequences, computing DNA distances, estimating trees
  with distance-based methods, and a range of methods for comparative
  analyses and analysis of diversification. Functionalities are also
  provided for programming new phylogenetic methods.

  The complete list of functions can be displayed with
  \code{library(help = ape)}.

  More information on \pkg{ape} can be found at \url{http://ape.mpl.ird.fr/}.
}

\author{
  Emmanuel Paradis, Ben Bolker, Julien Claude, Hoa Sien Cuong, Richard
  Desper, Benoit Durand, Julien Dutheil, Olivier Gascuel, Gangolf Jobb,
  Christoph Heibl, Daniel Lawson, Vincent Lefort, Pierre Legendre, Jim
  Lemon, Yvonnick Noel, Johan Nylander, Rainer Opgen-Rhein, Korbinian
  Strimmer, Damien de Vienne

  Maintainer: Emmanuel Paradis <Emmanuel.Paradis@ird.fr>
}
\references{
  Paradis, E. (2006) \emph{Analyses of Phylogenetics and Evolution with
    R}. Springer, New York.

  Paradis, E., Claude, J. and Strimmer, K. (2004) APE: analyses of
  phylogenetics and evolution in R language. \emph{Bioinformatics},
  \bold{20}, 289--290.
}
\keyword{package}
