% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{apexcharter-shiny-grid}
\alias{apexcharter-shiny-grid}
\alias{apexgridOutput}
\alias{renderApexgrid}
\title{Shiny bindings for grid with apexcharter}
\usage{
apexgridOutput(outputId)

renderApexgrid(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{expr}{An expression that generates a apexcharter grid.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An Apexcharts output that can be included in the application UI.
}
\description{
Output and render functions for using apexcharter grid within Shiny
applications and interactive Rmd documents.
}
\examples{

library(shiny)
library(apexcharter)

ui <- fluidPage(
  
  tags$h2("Apexcharts Grid Example"),
  
  apexgridOutput("myfacet")
  
)

server <- function(input, output, session) {
  
  output$myfacet <- renderApexgrid({
    a1 <- apex(mpg, aes(manufacturer), type = "bar")
    a2 <- apex(mpg, aes(trans), type = "column")
    a3 <- apex(mpg, aes(drv), type = "pie")
    
    apex_grid(
      a1, a2, a3, 
      grid_area = c("1 / 1 / 3 / 2", "1 / 2 / 2 / 4", "2 / 2 / 3 / 4"),
      ncol = 3, 
      nrow = 2,
      height = "600px"
    )
  })
  
}

if (interactive())
  shinyApp(ui, server)
}
