% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_lc.R
\name{apollo_lc}
\alias{apollo_lc}
\title{Calculates the likelihood of a latent class model}
\usage{
apollo_lc(lc_settings, apollo_inputs, functionality)
}
\arguments{
\item{lc_settings}{List of arguments used by \code{apollo_lc}. It must include the following.
\itemize{
  \item inClassProb: List of probabilities. Conditional likelihood for each class. One element per class, in the same order as \code{classProb}.
  \item classProb: List of probabilities. Allocation probability for each class. One element per class, in the same order as \code{inClassProb}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate" Used for model estimation.
  \item "prediction" Used for model predictions.
  \item "validate" Used for validating input.
  \item "zero_LL" Used for calculating null likelihood.
  \item "conditionals" Used for calculating conditionals.
  \item "output" Used for preparing output after model estimation.
  \item "raw" Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item "estimate": vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item "prediction": List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the chosen alternative probability.
          \item "validate": Boolean. Returns TRUE if all tests are passed.
          \item "zero_LL": vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item "conditionals": Same as "prediction".
          \item "output": Same as "estimate" but also writes summary of choices into temporary file (later read by \code{apollo_modelOutput}).
          \item "raw": Same as "prediction".
        }
}
\description{
Using the conditional likelihoods of each latent class, as well as teir classification probabilities, calculate the weighted likelihood of the whole model.
}
\examples{
data(apollo_modeChoiceData)
database <- apollo_modeChoiceData
rm(apollo_modeChoiceData)
N <- nrow(database)
lc_settings <- list(inClassProb=list(rnorm(N), rnorm(N)),
                    classProb=list(stats::runif(N), stats::runif(N)))
apollo_control <- list(indivID="ID")
x <- apollo_lc(lc_settings, apollo_control, functionality="estimate")
summary(x)
}
