% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_modelOutput.R
\name{apollo_modelOutput}
\alias{apollo_modelOutput}
\title{Prints estimation results to console}
\usage{
apollo_modelOutput(model, modelOutput_settings = NA)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{modelOutput_settings}{List of options. It can include the following.
\itemize{
  \item printClassical: Boolean. TRUE for printing classical standard errors. TRUE by default.
  \item printPVal: Boolean. TRUE for printing p-values. FALSE by default.
  \item printT1: Boolean. If TRUE, t-test for H0: apollo_beta=1 are printed. FALSE by default.
  \item printDiagnostics: Boolean. TRUE for printing summary of choices in database and other diagnostics. TRUE by default.
  \item printCovar: Boolean. TRUE for printing parameters covariance matrix. If \code{printClassical=TRUE}, both classical and robust matrices are printed. FALSE by default.
  \item printCorr: Boolean. TRUE for printing parameters correlation matrix. If \code{printClassical=TRUE}, both classical and robust matrices are printed. FALSE by default.
  \item printOutliers: Boolean or Scalar. TRUE for printing 20 individuals with worst average fit across observations. FALSE by default. If Scalar is given, this replaces the default of 20.
  \item printChange: Boolean. TRUE for printing difference between starting values and estimates. FALSE by default.
}}
}
\value{
A matrix of coefficients, s.d. and t-tests (invisible)
}
\description{
Prints estimation results to console. Amount of information presented can be adjusted through arguments.
}
\details{
Prints to screen the output of a model previously estimated by apollo_estimate()
}
