% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_panelProd.R
\name{apollo_panelProd}
\alias{apollo_panelProd}
\title{Calculates product of panel observations.}
\usage{
apollo_panelProd(P, apollo_inputs, functionality)
}
\arguments{
\item{P}{List of vectors, matrices or 3-dim arrays. Likelihood of the model components.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{functionality}{Character. Can take different values depending on desired output.
\describe{
  \item{"estimate"}{For model estimation, returns probabilities of chosen alternatives.}
  \item{"prediction"}{For model predictions, returns probabilities of all alternatives.}
  \item{"validate"}{Validates input.}
  \item{"zero_LL"}{Return probabilities with all parameters at zero.}
  \item{"conditionals"}{For conditionals, returns probabilities of chosen alternatives.}
  \item{"output"}{Checks that the model is well defined.}
  \item{"raw"}{For debugging, returns probabilities of all alternatives}
}}
}
\value{
Probabilities at the individual level.
}
\description{
Multiplies likelihood of observations from the same individual, or adds the log of them.
}
\details{
This function should be called inside apollo_probabilities only if the data has a panel structure.
It should be called after apollo_avgIntraDraws if intra-individual draws are used.
}
