% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_nl.R
\name{apollo_nl}
\alias{apollo_nl}
\title{Calculates probabilities of a nested logit}
\usage{
apollo_nl(nl_settings, functionality)
}
\arguments{
\item{nl_settings}{List of inputs of the NL model. It shoud contain the following.
\itemize{
   \item alternatives: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
   \item avail: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
   \item choiceVar: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
   \item V: Named list of deterministic utilities . Utilities of the alternatives. Names of elements must match those in \code{alternatives.}
   \item nlNests: List of numeric scalars or vectors. Lambda parameters for each nest. Elements must be named with the nest name. The lambda at the root is fixed to 1 if excluded (recommended).
   \item nlStructure: Named list of character vectors. As many elements as nests, it must include the "root". Each element contains the names of the nests or alternatives that belong to it. Element names must match those in \code{nlNests}.
   \item rows: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
}}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate": Used for model estimation.
  \item "prediction": Used for model predictions.
  \item "validate": Used for validating input.
  \item "zero_LL": Used for calculating null likelihood.
  \item "conditionals": Used for calculating conditionals.
  \item "output": Used for preparing output after model estimation.
  \item "raw": Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item "estimate": vector/matrix/array. Returns the probabilities for the chosen alternative for each observation.
          \item "prediction": List of vectors/matrices/arrays. Returns a list with the probabilities for all alternatives, with an extra element for the chosen alternative probability.
          \item "validate": Boolean. Returns TRUE if all tests are passed.
          \item "zero_LL": vector/matrix/array. Returns the probability of the chosen alternative when all parameters are zero.
          \item "conditionals": Same as "prediction".
          \item "output": Same as "estimate" but also writes summary of choices into temporary file (later read by \code{apollo_modelOutput}).
          \item "raw": Same as "prediction".
        }
}
\description{
Calculates probabilities of a nested logit model.
}
\details{
In this implementation of the nested logit model, each nest must have a lambda parameter associated to it.
For the model to be consistent with utility maximisation, the estimated value of the Lambda parameter of all nests
should be between 0 and 1. Lambda parameters are inversely proportional to the correlation between the error terms of 
alternatives in a nest. If lambda=1, then there is no relevant correlation between the unobserved
utility of alternatives in that nest.
The tree must contain an upper nest called \code{"root"}. The lambda parameter of the root is automatically
set to 1 if not specified in \code{nlNests}. And while setting it to another value is possible, it is not
recommended.
}
\examples{
### Load data
data(apollo_modeChoiceData)
database <- apollo_modeChoiceData
rm(apollo_modeChoiceData)

### Parameters
b = list(asc_1=0, asc_2=0, asc_3=0, asc_4=0, tt=0, tc=0, acc=0, lambda=0.5)

V = list()
V[['car' ]] = b$asc_1 + b$tt*database$time_car  + b$tc*database$cost_car
V[['bus' ]] = b$asc_2 + b$tt*database$time_bus  + b$tc*database$cost_bus  +
              b$acc*database$access_bus
V[['air' ]] = b$asc_3 + b$tt*database$time_air  + b$tc*database$cost_air  +
              b$acc*database$access_air
V[['rail']] = b$asc_4 + b$tt*database$time_rail + b$tc*database$cost_rail +
              b$acc*database$access_rail

### NL settings
nl_settings <- list(
   alternatives = c(car=1, bus=2, air=3, rail=4),
   avail        = list(car=database$av_car, bus=database$av_bus,
                       air=database$av_air, rail=database$av_rail),
   choiceVar    = database$choice,
   V            = V,
   nlNests      = list(root=1, public=b$lambda),
   nlStructure  = list(root=c("car", "public"), public=c("bus","air","rail"))
)

### Compute choice probabilities using NL model
apollo_nl(nl_settings, functionality="estimate")
}
