% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_makeDraws.R
\name{apollo_makeDraws}
\alias{apollo_makeDraws}
\title{Creates draws for models with mixing}
\usage{
apollo_makeDraws(apollo_inputs, silent = FALSE)
}
\arguments{
\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{silent}{Boolean. If true, then no information is printed to console or default output. FALSE by default.}
}
\value{
List. Each element is an array of draws representing a random component of the mixing model.
}
\description{
Creates a list containing all draws necessary to estimate a model with mixing.
}
\details{
Internal use only. Called by \code{apollo_validateInputs}.
#' This function creates a list whose elements are the sets of draws requested by the user for use in a model with mixing.
If the model does not include mixing, then it is not necessary to run this function.
The number of draws have a massive impact on memory usage and estimation time. Memory usage and number of computations
scale geometrically as N*interNDraws*intraNDraws (where N is the number of observations). Special care should be taken
when using both inter and intra draws, as memory usage can easily reach the GB order of magnitude. Also, keep in
mind that using several threads (i.e. multicore) at least doubles the memory usage.
This function returns a list, with each element representing a random component of the mixing model. The dimensions 
of the array depend on the type of draws used.
\enumerate{
           \item If only inter-individual draws are used, then draws are stored as 2-dimensional arrays (i.e. matrices).
           \item If intra-individual draws are used, then draws are stored as 3-dimensional arrays.
           \item The first dimension of the arrays (rows) correspond with the observations in the database.
           \item The second dimension of the arrays (columns) correspond to the number of inter-individual draws.
           \item The third dimension of the arrays correspond to the number of intra-individual draws.
}
}
