% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validateInputs.R
\name{apollo_validateInputs}
\alias{apollo_validateInputs}
\title{Prepares input for \code{apollo_estimate}}
\usage{
apollo_validateInputs(
  apollo_beta = NA,
  apollo_fixed = NA,
  database = NA,
  apollo_control = NA,
  apollo_HB = NA,
  apollo_draws = NA,
  apollo_randCoeff = NA,
  apollo_lcPars = NA,
  recycle = FALSE,
  silent = FALSE
)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.}

\item{database}{data.frame. Data used by model.}

\item{apollo_control}{List. Options controlling the running of the code. User input is required for all settings except those with a default or marked as optional. 
\itemize{
  \item \strong{\code{calculateLLC}}: Boolean. TRUE if user wants to calculate LL at constants (if applicable). - TRUE by default.
  \item \strong{\code{HB}}: Boolean. TRUE if using RSGHB for Bayesian estimation of model.
  \item \strong{\code{indivID}}: Character. Name of column in the database with each decision maker's ID.
  \item \strong{\code{mixing}}: Boolean. TRUE for models that include random parameters.
  \item \strong{\code{modelDescr}}: Character. Description of the model. Used in output files.
  \item \strong{\code{modelName}}: Character. Name of the model. Used when saving the output to files.
  \item \strong{\code{nCores}}: Numeric>0. Number of cores to use in calculations of the model likelihood.
  \item \strong{\code{noDiagnostics}}: Boolean. TRUE if user does not wish model diagnostics to be printed - FALSE by default.
  \item \strong{\code{noValidation}}: Boolean. TRUE if user does not wish model input to be validated before estimation - FALSE by default.
  \item \strong{\code{outputDirectory}}: Character. Optional directory for outputs if different from working director - empty by default
  \item \strong{\code{panelData}}: Boolean. TRUE if there are multiple observations (i.e. rows) for each decision maker - Automatically set based on \code{indivID} by default.
  \item \strong{\code{seed}}: Numeric. Seed for random number generation.
  \item \strong{\code{weights}}: Character. Name of column in database containing weights for estimation.
  \item \strong{\code{workInLogs}}: Boolean. TRUE for increased numeric precision in models with panel data - FALSE by default.
}}

\item{apollo_HB}{List. Contains options for Bayesian estimation. See \code{?RSGHB::doHB} for details.
Parameters \code{modelname}, \code{gVarNamesFixed}, \code{gVarNamesNormal},
\code{gDIST}, \code{svN} and \code{FC} are automatically set based on the
other arguments of this function.
Other settings to include are the following.
\itemize{
  \item \strong{\code{constraintNorm}}: Character vector. Constraints for \emph{random} coefficients 
                                       in bayesian estimation. Constraints can be written as 
                                       "b1>b2", "b1<b2", "b1>0", or "b1<0".
  \item \strong{\code{fixedA}}: Named numeric vector. Contains the names and fixed mean values of 
                               random parameters. For example, c(b1=0) fixes the mean of b1 to zero.
  \item \strong{\code{fixedD}}: Named numeric vector. Contains the names and fixed variance of 
                               random parameters. For example, c(b1=1) fixes the variance of b1 to zero.
  \item \strong{\code{gNCREP}}: Numeric. Number of burn-in iterations to use prior to convergence (default=10^5).
  \item \strong{\code{gNEREP}}: Numeric. Number of iterations to keep for averaging after convergence has been reached (default=10^5).
  \item \strong{\code{gINFOSKIP}}: Numeric. Number of iterations between printing/plotting information about the iteration process (default=250).
  \item \strong{\code{hbDist}}: \emph{Mandatory} setting. A named character vector determining
                               the distribution of each parameter to be estimated. Possible 
                               values are as follows.
                               \itemize{
                                 \item \strong{\code{"CN+"}}: Positive censored normal.
                                 \item \strong{\code{"CN-"}}: Negative censored normal.
                                 \item \strong{\code{"DNE"}}: Parameter kept at its starting value (not estimated).
                                 \item \strong{\code{"JSB"}}: Johnson SB.
                                 \item \strong{\code{"LN+"}}: Positive log-normal.
                                 \item \strong{\code{"LN-"}}: Negative log-normal.
                                 \item \strong{\code{"N"}}: Normal.
                                 \item \strong{\code{"NR"}}: Fixed (as in non-random) parameter.
                               }
}}

\item{apollo_draws}{List of arguments describing the inter and intra individual draws. Required only if \code{apollo_control$mixing = TRUE}. Unused elements can be ommited.
\itemize{
  \item \strong{\code{interDrawsType}}: Character. Type of inter-individual draws ('halton','mlhs','pmc','sobol','sobolOwen',
                               'sobolFaureTezuka', 'sobolOwenFaureTezuka' or the name of an object loaded in memory,
                               see manual in www.ApolloChoiceModelling.com for details).
  \item \strong{\code{interNDraws}}: Numeric scalar (>=0). Number of inter-individual draws per individual. Should be set to 0 if not using them.
  \item \strong{\code{interNormDraws}}: Character vector. Names of normaly distributed inter-individual draws.
  \item \strong{\code{interUnifDraws}}: Character vector. Names of uniform-distributed inter-individual draws.
  \item \strong{\code{intraDrawsType}}: Character. Type of intra-individual draws ('halton','mlhs','pmc','sobol','sobolOwen','sobolFaureTezuka', 'sobolOwenFaureTezuka' or the name of an object loaded in memory).
  \item \strong{\code{intraNDraws}}: Numeric scalar (>=0). Number of intra-individual draws per individual. Should be set to 0 if not using them.
  \item \strong{\code{intraUnifDraws}}: Character vector. Names of uniform-distributed intra-individual draws.
  \item \strong{\code{intraNormDraws}}: Character vector. Names of normaly distributed intra-individual draws.
}}

\item{apollo_randCoeff}{Function. Used with mixing models. Constructs the random parameters of a mixing model. Receives two arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters. 
  \item \strong{\code{apollo_inputs}}: The output of this function (\code{apollo_validateInputs}).
}}

\item{apollo_lcPars}{Function. Used with latent class models. Constructs a list of parameters for each latent class. Receives two arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters. 
  \item \strong{\code{apollo_inputs}}: The output of this function (\code{apollo_validateInputs}).
}}

\item{recycle}{Logical. If TRUE, an older version of \code{apollo_inputs} is looked for in the calling environment (parent frame), and any
element in that old version created by the user is copied into the new \code{apollo_inputs} returned by this function.
For \code{recycle=TRUE} to work, the old version of \code{apollo_inputs} \strong{must} be named "apollo_inputs".
If FALSE, nothing is copied from any older version of apollo_inputs. FALSE is the default.}

\item{silent}{Logical. TRUE to keep the function from printing to the console. Default is FALSE.}
}
\value{
List grouping several required input for model estimation.
}
\description{
Searches the user work space (.GlobalEnv) for all necessary input to run \code{apollo_estimate}, and packs it in a single list.
}
\details{
All arguments to this function are optional. If the function is called without arguments, then it it will look in
the user workspace (i.e. the global environment) for variables with the same name as its omitted arguments.
We strongly recommend users to visit \url{http://www.apollochoicemodelling.com/} for examples on how to use Apollo.
In the website, users will also find a detailed manual and a user-group for help and further reference.
}
