% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_insertFunc.R
\name{apollo_insertFunc}
\alias{apollo_insertFunc}
\title{Modifies function to make it compatible with analytic gradients}
\usage{
apollo_insertFunc(f, like = TRUE, randCoeff = FALSE, lcPars = FALSE)
}
\arguments{
\item{f}{Function. Expressions inside it will be turned into functions. Usually \code{apollo_probabilities} or 
\code{apollo_randCoeff}.}

\item{like}{Logical. Must be TRUE if \code{f} is \code{apollo_probabilities}. FALSE otherwise.}

\item{randCoeff}{Logical. Must be TRUE if \code{f} is \code{apollo_randCoeff}. FALSE otherwise.}

\item{lcPars}{Logical. Must be TRUE if \code{f} is \code{apollo_lcPars}. FALSE otherwise.}
}
\value{
Function \code{f} but with relevant expressions turned into function definitions.
}
\description{
Takes a likelihood function and inserts \code{function ()} before key elements to allow for analytic gradient calculation
}
\details{
It modifies the definition of the following models.
\itemize{
  \item \strong{\code{apollo_mnl}}: Turns all elements inside \code{mnl_settings$V} into functions.
  \item \strong{\code{apollo_ol}}: Turns \code{ol_settings$V} and all elements inside \code{ol_settings$tau} into functions.
  \item \strong{\code{apollo_op}}: Turns \code{op_settings$V} and all elements inside \code{op_settings$tau} into functions.
  \item \strong{\code{apollo_normalDensity}}: Turns \code{normalDensity_settings$xNormal}, \code{normalDensity_settings$mu} and \code{normalDensity_settings$sigma} into functions.
}
It can only track a maximum of 3 levels of depth in definitions. For example:
\code{
V <- list()
V[["A"]] <- b1*x1A + b2*x2A
V[["B"]] <- b1*x1B + b2*x2B
mnl_settings1 <- list(alternatives=c("A", "B"), V = V, choiceVar= Y, avail = 1, componentName="MNL1")
P[["MNL1"]] <- apollo_mnl(mnl_settings1, functionality)
}
But it may not be able to deal with the following:
\code{
VA <- b1*x1A + b2*x2A
V <- list()
V[["A"]] <- VA
V[["B"]] <- b1*x1B + b2*x2B
mnl_settings1 <- list(alternatives=c("A", "B"), V = V, choiceVar= Y, avail = 1, componentName="MNL1")
P[["MNL1"]] <- apollo_mnl(mnl_settings1, functionality)
}
But that might be enough given how apollo_dVdB works.
}
