% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_request.R
\name{rs_request}
\alias{rs_request}
\title{AppEEARS data request and download}
\usage{
rs_request(
  request,
  user,
  transfer = TRUE,
  path = tempdir(),
  time_out = 3600,
  job_name,
  verbose = TRUE
)
}
\arguments{
\item{request}{nested list with query parameters following the layout
as specified on the ECMWF APIs page}

\item{user}{user (email address or ID) provided by the ECMWF data service,
used to retrieve the token set by \code{\link[appeears]{rs_set_key}}}

\item{transfer}{logical, download data TRUE or FALSE (default = TRUE)}

\item{path}{path were to store the downloaded data}

\item{time_out}{how long to wait on a download to start (default =
\code{3*3600} seconds).}

\item{job_name}{optional name to use as an RStudio job and as output variable
name. It has to be a syntactically valid name.}

\item{verbose}{show feedback on processing}
}
\value{
the path of the downloaded (requested file) or the an R6 object
with download/transfer information
}
\description{
Stage a data request, and optionally download the data to disk. Alternatively
you can only stage requests, logging the request URLs to submit download
queries later on using \code{\link[appeears]{rs_transfer}}.
}
\examples{

\dontrun{
# specifiy a task/request as a
# data frame
df <- data.frame(
 task = "grand canyon",
 subtask = c("test1", "test2"),
 latitude = c(36.206228, 36.206228),
 longitude = c(-112.127134, -112.127134),
 start = c("2018-01-01","2018-01-01"),
 end = c("2018-01-15","2018-01-15"),
 product = c("MOD11A2.061","MCD12Q2.006"),
 layer = c("LST_Day_1km","Dormancy")
)

# build a proper JSON query
task <- rs_build_task(df = df)

# request the task to be executed
rs_request(
 request = task,
 user = "earth_data_user",
 transfer = TRUE,
 path = "~/some_path",
 verbose = TRUE
)
}
}
\seealso{
\code{\link[appeears]{rs_set_key}}
\code{\link[appeears]{rs_transfer}}
}
\author{
Koen Hufkens
}
