% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_transfer.R
\name{rs_transfer}
\alias{rs_transfer}
\title{AppEEARS data transfer function}
\usage{
rs_transfer(task_id, user, path = tempdir(), verbose = TRUE)
}
\arguments{
\item{task_id}{R6 \code{\link[appeears]{rs_request}}) query output or task id}

\item{user}{user (email address) used to sign up for the ECMWF data service,
used to retrieve the token set by \code{\link[appeears]{rs_set_key}}.}

\item{path}{path were to store the downloaded data}

\item{verbose}{show feedback on data transfers}
}
\value{
data on disk as specified by a
\code{\link[appeears]{rs_request}}
}
\description{
Returns the contents of the requested url as a NetCDF file downloaded
to disk or the current status of the requested transfer.
}
\examples{

\dontrun{
# set key
rs_set_key(user = "test", password = "123")

# request data and grab url and try a transfer
r <- rs_request(request, "test", transfer = FALSE)

# check transfer, will download if available
rs_transfer(r$get_task_id(), user = "test")
}
}
\seealso{
\code{\link[appeears]{rs_set_key}}
\code{\link[appeears]{rs_request}}
}
\author{
Koen Hufkens
}
