% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{apple_apps}
\alias{apple_apps}
\title{Apple App Store Applications}
\format{
A data frame with 2 columns and 202 rows
\describe{
\item{app_name}{Application name}
\item{app_id}{Apple ID of the application}
}
}
\source{
<https://apps.apple.com>
}
\usage{
apple_apps
}
\description{
A dataset containing a selection of apps available on the Apple App Store
with a corresponding ID that can be used in {appler} functions.

To see more information about the application online, you can add the following
URL in your browser: apps.apple.com/app/id<id> where <id> is the `app_id`
column
}
\details{
All of the applications in this table are available in Canada (`country_id = "ca"`)
at the time of writing (2022-12-03), however they might not be available in all countries,
or have a different application name.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get information about Microsoft Teams
teams <- apple_apps[apple_apps$app_name == "Microsoft Teams", "app_id"]

# Search for any other apps
search_apple(term = "Microsoft Teams", country = "ca", media = "software")

# General application information including average rating
lookup_apple(teams, country = "ca")

# Latest application reviews
get_apple_reviews(teams, country = "ca")

# Current position on App store
get_apple_chart_postion(teams, country = "ca")
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
