% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.apd_similarity}
\alias{autoplot.apd_similarity}
\title{Plot the cumulative distribution function for similarity metrics}
\usage{
\method{autoplot}{apd_similarity}(object, ...)
}
\arguments{
\item{object}{An object produced by \code{apd_similarity}.}

\item{...}{Not currently used.}
}
\value{
A \code{ggplot} object that shows the cumulative probability versus the
unique similarity values in the training set. Not that for large samples,
this is an approximation based on a random sample of 5,000 training set
points.
}
\description{
Plot the cumulative distribution function for similarity metrics
}
\examples{
set.seed(535)
tr_x <- matrix(
  sample(0:1, size = 20 * 50, prob = rep(.5, 2), replace = TRUE),
  ncol = 20
)
model <- apd_similarity(tr_x)
}
