% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randunif.R
\name{randunif}
\alias{randunif}
\title{Multivariable Random Uniform data}
\usage{
randunif(n, mu, Cov, Q)
}
\arguments{
\item{n}{the number of rows of observations in the dataset}

\item{mu}{a vector containing the column means of the dataset}

\item{Cov}{a covariance matrix}

\item{Q}{an optional orthogonal matrix}
}
\value{
A simulated matrix of values based on the input parameters is returned.
}
\description{
Generate a simulated multivariable random uniformly distributed dataset
using the method of Cholesky Decomposition.
}
\examples{
## Simulated data based on the iris dataset
mu <- c(rep(0, 4))
covmatr <- matrix(c(0.7, -0.04, 1.3, 0.5, -0.04, 0.2, -0.3, -0.1,
1.3, -0.3, 3.1, 1.3, 0.5, -0.1, 1.3, 0.6), ncol = 4)
sim.dat <- randunif(n = 100, mu = mu, Cov = covmatr)
head(sim.dat)

}
\references{
Rizzo M. L., \emph{"Statistical Computing with R", Chapman & Hall/CRC} (2007)
}

