% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzBoundary.R
\name{hzTopographyCodeToLineType}
\alias{hzTopographyCodeToLineType}
\title{Convert Horizon Boundary Topography Distinctness to Line Type}
\usage{
hzTopographyCodeToLineType(
  x,
  codes = c("S", "W", "I", "B"),
  lty = c(1, 2, 3, 4)
)
}
\arguments{
\item{x}{vector of boundary topography codes to be converted}

\item{codes}{code values, adjust as needed}

\item{lty}{line types}
}
\value{
vector of line types with same length as \code{x}
}
\description{
This function will convert USDA-NCSS horizon boundary topography codes into line types, based on the \href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}.
}
\examples{

# example data
data(sp1)

# compute 1/2 transitional zone thickness from distinctness codes
sp1$hzdo <- hzDistinctnessCodeToOffset(sp1$bound_distinct)

# convert colors from Munsell to hex-encoded RGB
sp1$soil_color <- with(sp1, munsell2rgb(hue, value, chroma))

# promote to SoilProfileCollection
depths(sp1) <- id ~ top + bottom

# adjust margins
op <- par(mar=c(0,0,0,1.5))

# sketches, adjust width, adjust text size, include coded hz distinctness offsets
plotSPC(sp1, width=0.3, cex.names=0.75, hz.distinctness.offset = 'hzdo')

# clean-up
par(op)
}
\references{
\href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link{plotSPC}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
