% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{downloadWithRetries}
\alias{downloadWithRetries}
\title{Download and Cache a Dataset}
\usage{
downloadWithRetries(
  url,
  destdir,
  destfile,
  quiet = FALSE,
  age = argoDefaultProfileAge(),
  retries = 3,
  async = FALSE,
  debug = 0
)
}
\arguments{
\item{url}{character value giving the full URL of a file to be downloaded.}

\item{destdir}{character value indicating the directory in which to store
downloaded files. The default value is to compute this using
\code{\link[=argoDefaultDestdir]{argoDefaultDestdir()}}, which returns \verb{~/data/argo} by default,
although it also provides ways to set other values using
\code{\link[=options]{options()}}.
Set \code{destdir=NULL}
if \code{destfile} is a filename with full path information.
File clutter is reduced by creating a top-level directory called
\code{data}, with subdirectories for various file types; see
\dQuote{Examples}.}

\item{destfile}{either character value indicating the name of the file
or \code{NULL} (the default), in which case the file name is constructed from
the other parameters of the function call, so that subsequent calls with
the same parameters will yield the same result; this is useful
for caching.}

\item{quiet}{logical value; use \code{TRUE} to show more
verbose information when downloading files.
(Problems will still be reported, though.)}

\item{age}{a numerical value indicating a time interval, in days.  If the file
to be downloaded from the server already exists locally, and was created
is less than \code{age} days in the past, it will not be downloaded.  The default,
\code{\link[=argoDefaultProfileAge]{argoDefaultProfileAge()}}, is one year.  Setting \code{age=0} will force a download.}

\item{retries}{integer telling how many times to retry a download,
if the first attempt fails.}

\item{async}{Use \code{TRUE} to perform requests asynchronously. This is much
faster for many small files (e.g., Argo profile NetCDF files).}

\item{debug}{integer value indicating level of debugging. If this
is less than 1, no debugging is done. Otherwise, some functions
will print debugging information.  If a function call fails, the
first step should be to rerun the function with \code{debug=1},
to see if the output suggests a problem in the call.}
}
\value{
A character value indicating the full pathname to the downloaded file,
or \code{NA}, if there was a problem with the download.
}
\description{
General function for downloading and caching a dataset.
}
\author{
Dan Kelley
}
