% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ari_spin.R
\name{ari_spin}
\alias{ari_spin}
\alias{have_polly}
\title{Create a video from images and text}
\usage{
ari_spin(
  images,
  paragraphs,
  output = tempfile(fileext = ".mp4"),
  voice = text2speech::tts_default_voice(service = service),
  service = ifelse(have_polly(), "amazon", "google"),
  subtitles = FALSE,
  ...
)

have_polly()
}
\arguments{
\item{images}{A vector of paths to images.}

\item{paragraphs}{A vector strings that will be spoken by Amazon Polly.}

\item{output}{A path to the video file which will be created.}

\item{voice}{The voice you want to use. See 
\code{\link[text2speech]{tts_voices}} for more information 
about what voices are available.}

\item{service}{speech synthesis service to use,
passed to \code{\link[text2speech]{tts}}}

\item{subtitles}{Should a \code{.srt} file be created with subtitles? The
default value is \code{FALSE}. If \code{TRUE} then a file with the same name
as the \code{output} argument will be created, but with the file extension
\code{.srt}.}

\item{...}{additional arguments to \code{\link{ari_stitch}}}
}
\value{
The output from \code{\link{ari_stitch}}
}
\description{
Given equal length vectors of paths to images (preferably \code{.jpg}s
or \code{.png}s) and strings which will be
\code{\link[aws.polly]{synthesize}}d by
\href{https://aws.amazon.com/polly/}{Amazon Polly} or 
any other synthesizer available in
\code{\link[text2speech]{tts}}, this function creates an
\code{.mp4} video file where each image is shown with
its corresponding narration. This function uses \code{\link{ari_stitch}} to
create the video.
}
\details{
This function needs to connect to
\href{https://aws.amazon.com/}{Amazon Web Services} in order to create the
narration. You can find a guide for accessing AWS from R
\href{http://seankross.com/2017/05/02/Access-Amazon-Web-Services-in-R.html}{here}.
For more information about how R connects
to Amazon Polly see the \code{\link[aws.polly]{aws.polly}} documentation 
\href{https://github.com/cloudyr/aws.polly}{here}.
}
\examples{
\dontrun{

slides <- system.file("test", c("mab2.png", "mab1.png"),
package = "ari")
sentences <- c("Welome to my very interesting lecture.",
               "Here are some fantastic equations I came up with.")
ari_spin(slides, sentences, voice = "Joey")

}

}
