% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-numeric}
\alias{predicate-numeric}
\alias{is_missing}
\alias{is_zero}
\alias{is_odd}
\alias{is_even}
\alias{is_positive}
\alias{is_negative}
\alias{is_whole}
\title{Numeric Predicates}
\usage{
is_missing(x, finite = FALSE)

is_zero(x, na.rm = FALSE)

is_odd(x, na.rm = FALSE)

is_even(x, na.rm = FALSE)

is_positive(x, strict = FALSE, na.rm = FALSE)

is_negative(x, strict = FALSE, na.rm = FALSE)

is_whole(x, na.rm = FALSE, tolerance = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{A \code{\link{numeric}} object to be tested.}

\item{finite}{A \code{\link{logical}} scalar: should non-\code{\link{finite}} values also be
removed?}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values (including \code{NaN})
be omitted?}

\item{strict}{A \code{\link{logical}} scalar: should strict inequality be used?}

\item{tolerance}{A \code{\link{numeric}} scalar giving the tolerance to check within.}
}
\value{
A \code{\link{logical}} vector.
}
\description{
Check numeric objects:
\itemize{
\item \code{is_zero()} checks if an object contains only zeros.
\item \code{is_odd()} and \code{is_even()} check if a number is odd or even, respectively.
\item \code{is_positive()} and \code{is_negative} check if an object contains only
(strictly) positive or negative numbers.
\item \code{is_whole()} checks if an object only contains whole numbers.
}
}
\seealso{
Other predicates: 
\code{\link{predicate-graph}},
\code{\link{predicate-matrix}},
\code{\link{predicate-scalar}},
\code{\link{predicate-trend}},
\code{\link{predicate-type}},
\code{\link{predicate-utils}}
}
\concept{predicates}
