% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{replace_zero}
\alias{replace_zero}
\alias{replace_zero-method}
\alias{replace_zero,matrix-method}
\alias{replace_zero,data.frame-method}
\title{Replace Zeros}
\usage{
replace_zero(x, ...)

\S4method{replace_zero}{matrix}(x, value)

\S4method{replace_zero}{data.frame}(x, value)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{value}{A possible replacement value.}
}
\description{
Replaces zeros.
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add zero
k <- sample(1:25, 3, FALSE)
X[k] <- 0
X

## Remove rows with zero
remove_zero(X, margin = 1)

## Replace zero
replace_zero(X, value = 1)
}
\seealso{
Other data cleaning tools: 
\code{\link{clean_whitespace}()},
\code{\link{remove_Inf}()},
\code{\link{remove_NA}()},
\code{\link{remove_constant}()},
\code{\link{remove_empty}()},
\code{\link{remove_zero}()},
\code{\link{replace_Inf}()},
\code{\link{replace_NA}()},
\code{\link{replace_empty}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
