% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PutOptionsOverTime.R
\name{PutOptionsOverTime}
\alias{PutOptionsOverTime}
\title{Time Sensitivity Analysis for European Call Option}
\usage{
PutOptionsOverTime(
  stock_data,
  future_times,
  sell_value,
  max.p = 5,
  max.q = 5,
  method = "CSS-ML"
)
}
\arguments{
\item{stock_data}{Numeric vector of stock prices data.}

\item{future_times}{Numeric vector of the future times}

\item{sell_value}{Numeric value representing the sell value}

\item{max.p}{The maximum order of the autoregressive part of the ARMA model (default is 5).}

\item{max.q}{The maximum order of the moving average part of the ARMA model (default is 5).}

\item{method}{The way that the ARMA model is calculated, accepted values are "ML", "CSS-ML" and "CSS"}
}
\value{
Estimated values of a European put option at different future times
}
\description{
This function calculates the value of the a European put option for a list of future time values, given stock price data and a given buy value.
}
\examples{
library(stats)
library(forecast)

# Create simulated data
n = 100
set.seed(42)
arma_values = arima.sim(n = n, model = list(ar = c(0.6), ma = c(0.5, -0.5)))
linear_model = 5 + 1:n
stock_data = arma_values + linear_model

sell_value = 110
future_times = c(1, 3, 5)

PutOptionsOverTime(stock_data = stock_data, future_times = future_times, sell_value = sell_value)

}
