% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/4_NetworkModels.R
\name{ClosedJacksonNetwork}
\alias{ClosedJacksonNetwork}
\title{Obtains the main characteristics of a Closed Jackson Network model}
\usage{
ClosedJacksonNetwork(mu = c(5, 5, 10, 15), s = c(2, 2, 1, 1),
  p = matrix(c(0.25, 0.15, 0.2, 0.4, 0.15, 0.35, 0.2, 0.3, 0.5, 0.25, 0.15,
  0.1, 0.4, 0.3, 0.25, 0.05), 4, byrow = TRUE), n = 3)
}
\arguments{
\item{mu}{Vector of mean service rates}

\item{s}{Vector of servers at each node}

\item{p}{Routing matrix, where \ifelse{latex}{\eqn{p_{ij}}}{\out{<i>p<sub>ij</sub></i>}} is the routing probability from node i to node j}

\item{n}{Number of customers in the network}
}
\value{
Returns the next information of a Closed Jackson Network model:
\item{rho}{Traffic intensity: \eqn{\rho}}
\item{l}{Number of customers in the system: \eqn{L}}
\item{lq}{Number of customers in the queue: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
}
\description{
Obtains the main characteristics of a Closed Jackson Network model
}
\examples{
# A system is composed of 4 workstations
#interconnected. The monitoring of the
#system is carried out by three programs
#in continuous execution in some of the
#workstations. Once each program ends,
#it creates a copy of itself and sends this
#copy to be executed in any of the
#workstations, taking into account the
#following probabilities:

# Origin-destiny     1      2     3     4
#      1           0.25   0.15  0.20  0.40
#      2           0.15   0.35  0.20  0.30
#      3           0.50   0.25  0.15  0.10
#      4           0.40   0.30  0.25  0.05

#The servers 1 and 2 have two processors and
#each of one has a processing time following an
#exponential distribution and capacity of 5
#tasks per minute.
#The servers 3 and 4 have a single processor
#and they can serve 10 and 15 task per minute
#respectively.

ClosedJacksonNetwork(mu=c(5,5,10,15),
                     s=c(2,2,1,1),
                     p=matrix(c(0.25, 0.15, 0.20, 0.40,
                                0.15, 0.35, 0.20, 0.30,
                                0.50, 0.25, 0.15, 0.10,
                                0.40, 0.30, 0.25, 0.05), 4, byrow = TRUE),
                     n = 3)
}
\seealso{
Other AnaliticalModels: \code{\link{M_M_1_INF_H}};
  \code{\link{M_M_1_K}}; \code{\link{M_M_1}};
  \code{\link{M_M_INF}}; \code{\link{M_M_S_INF_H_Y}};
  \code{\link{M_M_S_INF_H}}; \code{\link{M_M_S_K}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

