context("Permutations")

test_that("Permutations - npermutations", {
    expect_equal(npermutations(5), 120)
    expect_equal(npermutations(x = LETTERS[1:5]), 120)
    expect_error(npermutations(13), "integer overflow")
    expect_error(npermutations(x = LETTERS[1:13]), "integer overflow")
    expect_equal(npermutations(13, bigz = TRUE), gmp::as.bigz("6227020800"))
    expect_equal(npermutations(0), 1)
    expect_error(npermutations(-1), "expect non-negative integer")
    expect_error(npermutations(1.5), "expect non-negative integer")
})

test_that("Permutations - permutations", {
    perm <- permutations(5)
    expect_equal(nrow(perm), 120)
    expect_equal(ncol(perm), 5)
    expect_equal(perm[1, ], 1:5)
    expect_equal(perm[120, ], 5:1)

    perm <- permutations(5, type = "r")
    expect_equal(nrow(perm), 120)
    expect_equal(ncol(perm), 5)
    expect_equal(perm[1, ], 1:5)
    expect_equal(perm[120, ], 5:1)

    perm <- permutations(5, type = "c")
    expect_equal(ncol(perm), 120)
    expect_equal(nrow(perm), 5)
    expect_equal(perm[, 1], 1:5)
    expect_equal(perm[, 120], 5:1)

    perm <- permutations(5, type = "l")
    expect_equal(length(perm), 120)
    expect_equal(perm[[1]], 1:5)
    expect_equal(perm[[120]], 5:1)

    perm <- permutations(x = LETTERS[1:5])
    expect_equal(nrow(perm), 120)
    expect_equal(ncol(perm), 5)
    expect_equal(perm[1, ], LETTERS[1:5])
    expect_equal(perm[120, ], LETTERS[5:1])

    expect_error(permutations(13), "too many results")
    expect_error(permutations(-1), "expect non-negative integer")
    expect_error(permutations(1.5), "expect non-negative integer")
    expect_equal(dim(permutations(0)), c(1, 0))
})

test_that("Permutations - ipermutations", {
    iperm <- ipermutations(5)
    perm <- permutations(5)
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(), 1:5)
    expect_equal(iperm$getnext(), c(1, 2, 3, 5, 4))
    iperm$getnext(110)
    expect_equal(nrow(iperm$getnext(10)), 8)
    expect_equal(iperm$getnext(), NULL)

    perm <- permutations(5, type = "r")
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(type = "r"), t(1:5))
    expect_equal(iperm$getnext(type = "r"), t(c(1, 2, 3, 5, 4)))
    iperm$getnext(110, type = "r")
    expect_equal(nrow(iperm$getnext(10, type = "r")), 8)
    expect_equal(iperm$getnext(type = "r"), NULL)

    perm <- permutations(5, type = "c")
    expect_equal(iperm$collect(type = "c"), perm)
    expect_equal(iperm$getnext(type = "c"), t(t(1:5)))
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 2, 3, 5, 4))))
    iperm$getnext(110, type = "c")
    expect_equal(ncol(iperm$getnext(10, type = "c")), 8)
    expect_equal(iperm$getnext(type = "c"), NULL)

    perm <- permutations(5, type = "l")
    expect_equal(iperm$collect(type = "l"), perm)
    expect_equal(iperm$getnext(type = "l"), list(1:5))
    expect_equal(iperm$getnext(type = "l"), list(c(1, 2, 3, 5, 4)))
    iperm$getnext(110, type = "l")
    expect_equal(length(iperm$getnext(10, type = "l")), 8)
    expect_equal(iperm$getnext(type = "l"), NULL)

    expect_error(ipermutations(-1), "expect non-negative integer")
    expect_error(ipermutations(1.5), "expect non-negative integer")
})


context("Multiset Permutations")

test_that("Multiset Permutations - npermutations", {
    expect_equal(npermutations(freq = c(3, 1, 3)), 140)
    expect_equal(npermutations(x = LETTERS[1:3], freq = c(3, 1, 3)), 140)
    expect_error(npermutations(freq = c(10, 5, 10)), "integer overflow")
    expect_error(npermutations(x = LETTERS[1:3], freq = c(10, 5, 10)), "integer overflow")
    expect_equal(npermutations(freq = c(10, 5, 10), bigz = TRUE), gmp::as.bigz("9816086280"))
    expect_equal(npermutations(freq = c(0, 0, 0)), 1)
    expect_error(npermutations(freq = c(2, -1, 0)), "expect non-negative integer")
    expect_error(npermutations(freq = c(2, 2, 1.5)), "expect non-negative integer")
})

test_that("Multiset Permutations - permutations", {
    perm <- permutations(freq = c(3, 1, 3))
    expect_equal(nrow(perm), 140)
    expect_equal(ncol(perm), 7)
    expect_equal(perm[1, ], c(1, 1, 1, 2, 3, 3, 3))
    expect_equal(perm[140, ], c(3, 3, 3, 2, 1, 1, 1))

    perm <- permutations(freq = c(3, 1, 3), type = "r")
    expect_equal(nrow(perm), 140)
    expect_equal(ncol(perm), 7)
    expect_equal(perm[1, ], c(1, 1, 1, 2, 3, 3, 3))
    expect_equal(perm[140, ], c(3, 3, 3, 2, 1, 1, 1))

    perm <- permutations(freq = c(3, 1, 3), type = "c")
    expect_equal(ncol(perm), 140)
    expect_equal(nrow(perm), 7)
    expect_equal(perm[, 1], c(1, 1, 1, 2, 3, 3, 3))
    expect_equal(perm[, 140], c(3, 3, 3, 2, 1, 1, 1))

    perm <- permutations(freq = c(3, 1, 3), type = "l")
    expect_equal(length(perm), 140)
    expect_equal(perm[[1]], c(1, 1, 1, 2, 3, 3, 3))
    expect_equal(perm[[140]], c(3, 3, 3, 2, 1, 1, 1))

    perm <- permutations(x = LETTERS[1:5], freq = c(3, 1, 3))
    expect_equal(nrow(perm), 140)
    expect_equal(ncol(perm), 7)
    expect_equal(perm[1, ], LETTERS[c(1, 1, 1, 2, 3, 3, 3)])
    expect_equal(perm[140, ], LETTERS[c(3, 3, 3, 2, 1, 1, 1)])

    expect_error(permutations(freq = c(10, 5, 10)), "too many results")
    expect_error(permutations(freq = c(2, -1, 0)), "expect non-negative integer")
    expect_error(permutations(freq = c(2, 2, 1.5)), "expect non-negative integer")
    expect_equal(dim(permutations(freq = c(0, 0, 0))), c(1, 0))
})

test_that("Multiset Permutations - ipermutations", {
    iperm <- ipermutations(freq = c(3, 1, 3))
    perm <- permutations(freq = c(3, 1, 3))
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(), c(1, 1, 1, 2, 3, 3, 3))
    expect_equal(iperm$getnext(), c(1, 1, 1, 3, 2, 3, 3))
    iperm$getnext(130)
    expect_equal(nrow(iperm$getnext(10)), 8)
    expect_equal(iperm$getnext(), NULL)

    perm <- permutations(freq = c(3, 1, 3), type = "r")
    expect_equal(iperm$collect(type = "r"), perm)
    expect_equal(iperm$getnext(type = "r"), t(c(1, 1, 1, 2, 3, 3, 3)))
    expect_equal(iperm$getnext(type = "r"), t(c(1, 1, 1, 3, 2, 3, 3)))
    iperm$getnext(130, type = "r")
    expect_equal(nrow(iperm$getnext(10, type = "r")), 8)
    expect_equal(iperm$getnext(type = "r"), NULL)

    perm <- permutations(freq = c(3, 1, 3), type = "c")
    expect_equal(iperm$collect(type = "c"), perm)
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 1, 1, 2, 3, 3, 3))))
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 1, 1, 3, 2, 3, 3))))
    iperm$getnext(130, type = "c")
    expect_equal(ncol(iperm$getnext(10, type = "c")), 8)
    expect_equal(iperm$getnext(type = "c"), NULL)

    perm <- permutations(freq = c(3, 1, 3), type = "l")
    expect_equal(iperm$collect(type = "l"), perm)
    expect_equal(iperm$getnext(type = "l"), list(c(1, 1, 1, 2, 3, 3, 3)))
    expect_equal(iperm$getnext(type = "l"), list(c(1, 1, 1, 3, 2, 3, 3)))
    iperm$getnext(130, type = "l")
    expect_equal(length(iperm$getnext(10, type = "l")), 8)
    expect_equal(iperm$getnext(type = "l"), NULL)

    expect_error(ipermutations(freq = c(2, -1, 0)), "expect non-negative integer")
    expect_error(ipermutations(freq = c(2, 2, 1.5)), "expect non-negative integer")
})
