% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositions.R
\name{compositions}
\alias{compositions}
\title{Compositions generator}
\usage{
compositions(n, k = NULL, descending = FALSE, layout = NULL,
  nitem = -1L, skip = NULL, index = NULL, nsample = NULL,
  drop = NULL)
}
\arguments{
\item{n}{an non-negative integer to be partitioned}

\item{k}{number of parts}

\item{descending}{an logical to use reversed lexicographical order}

\item{layout}{if "row", "column" or "list" is specified, the returned value would be a
"row-major" matrix, a "column-major" matrix or a list respectively}

\item{nitem}{number of compositions required, usually used with \code{skip}}

\item{skip}{the number of compositions skipped}

\item{index}{a vector of indices of the desired compositions}

\item{nsample}{sampling random compositions}

\item{drop}{vectorize a matrix or unlist a list}
}
\description{
This function generates the compositions of an non-negative interger \code{n} into \code{k} parts or parts of any sizes.
The results are in lexicographical or reversed lexicographical order.
}
\examples{
# all compositions of 4
compositions(4)
# reversed lexicographical order
compositions(4, descending = TRUE)

# fixed number of parts
compositions(6, 3)
# reversed lexicographical order
compositions(6, 3, descending = TRUE)

# column major
compositions(4, layout = "column")
compositions(6, 3, layout = "column")

# list output
compositions(4, layout = "list")
compositions(6, 3, layout = "list")

# zero sized compositions
dim(compositions(0))
dim(compositions(5, 0))
dim(compositions(5, 6))
dim(compositions(0, 0))
dim(compositions(0, 1))

}
\seealso{
\link{icompositions} for iterating compositions and \link{ncompositions} to calculate number of compositions
}
