% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet.R
\docType{class}
\name{ParquetWriterProperties}
\alias{ParquetWriterProperties}
\title{ParquetWriterProperties class}
\description{
This class holds settings to control how a Parquet file is read
by \link{ParquetFileWriter}.
}
\details{
The parameters \code{compression}, \code{compression_level}, \code{use_dictionary}
and write_statistics` support various patterns:
\itemize{
\item The default \code{NULL} leaves the parameter unspecified, and the C++ library
uses an appropriate default for each column (defaults listed above)
\item A single, unnamed, value (e.g. a single string for \code{compression}) applies to all columns
\item An unnamed vector, of the same size as the number of columns, to specify a
value for each column, in positional order
\item A named vector, to specify the value for the named columns, the default
value for the setting is used when not supplied
}

Unlike the high-level \link{write_parquet}, \code{ParquetWriterProperties} arguments
use the C++ defaults. Currently this means "uncompressed" rather than
"snappy" for the \code{compression} argument.
}
\section{Factory}{


The \code{ParquetWriterProperties$create()} factory method instantiates the object
and takes the following arguments:
\itemize{
\item \code{table}: table to write (required)
\item \code{version}: Parquet version, "1.0" or "2.0". Default "1.0"
\item \code{compression}: Compression type, algorithm \code{"uncompressed"}
\item \code{compression_level}: Compression level; meaning depends on compression algorithm
\item \code{use_dictionary}: Specify if we should use dictionary encoding. Default \code{TRUE}
\item \code{write_statistics}: Specify if we should write statistics. Default \code{TRUE}
\item \code{data_page_size}: Set a target threshold for the approximate encoded
size of data pages within a column chunk (in bytes). Default 1 MiB.
}
}

\seealso{
\link{write_parquet}
}
