% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension.R
\name{vctrs_extension_array}
\alias{vctrs_extension_array}
\alias{vctrs_extension_type}
\title{Extension type for generic typed vectors}
\usage{
vctrs_extension_array(x, ptype = vctrs::vec_ptype(x), storage_type = NULL)

vctrs_extension_type(x, storage_type = infer_type(vctrs::vec_data(x)))
}
\arguments{
\item{x}{A vctr (i.e., \code{\link[vctrs:vec_assert]{vctrs::vec_is()}} returns \code{TRUE}).}

\item{ptype}{A \code{\link[vctrs:vec_ptype]{vctrs::vec_ptype()}}, which is usually a zero-length
version of the object with the appropriate attributes set. This value
will be serialized using \code{\link[=serialize]{serialize()}}, so it should not refer to any
R object that can't be saved/reloaded.}

\item{storage_type}{The \link[=data-type]{data type} of the underlying storage
array.}
}
\value{
\itemize{
\item \code{vctrs_extension_array()} returns an \link{ExtensionArray} instance with a
\code{vctrs_extension_type()}.
\item \code{vctrs_extension_type()} returns an \link{ExtensionType} instance for the
extension name "arrow.r.vctrs".
}
}
\description{
Most common R vector types are converted automatically to a suitable
Arrow \link[=data-type]{data type} without the need for an extension type. For
vector types whose conversion is not suitably handled by default, you can
create a \code{\link[=vctrs_extension_array]{vctrs_extension_array()}}, which passes \code{\link[vctrs:vec_data]{vctrs::vec_data()}} to
\code{Array$create()} and calls \code{\link[vctrs:vec_proxy]{vctrs::vec_restore()}} when the \link{Array} is
converted back into an R vector.
}
\examples{
(array <- vctrs_extension_array(as.POSIXlt("2022-01-02 03:45", tz = "UTC")))
array$type
as.vector(array)

temp_feather <- tempfile()
write_feather(arrow_table(col = array), temp_feather)
read_feather(temp_feather)
unlink(temp_feather)
}
