% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.R
\name{show_exec_plan}
\alias{show_exec_plan}
\title{Show the details of an Arrow Execution Plan}
\usage{
show_exec_plan(x)
}
\arguments{
\item{x}{an \code{arrow_dplyr_query} to print the \code{ExecPlan} for.}
}
\value{
\code{x}, invisibly.
}
\description{
This is a function which gives more details about the logical query plan
that will be executed when evaluating an \code{arrow_dplyr_query} object.
It calls the C++ \code{ExecPlan} object's print method.
Functionally, it is similar to \code{dplyr::explain()}. This function is used as
the \code{dplyr::explain()} and \code{dplyr::show_query()} methods.
}
\examples{
\dontshow{if (arrow_with_dataset() && requireNamespace("dplyr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
mtcars \%>\%
  arrow_table() \%>\%
  filter(mpg > 20) \%>\%
  mutate(x = gear/carb) \%>\%
  show_exec_plan()
\dontshow{\}) # examplesIf}
}
