% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{transformer}
\alias{transformer}
\title{Do transformations in a desired order}
\usage{
transformer(
  x,
  rescale = c(1, 1),
  rotate = 0,
  nudge = 0,
  center = c(0, 0),
  degrees = FALSE,
  transformations = c("unitizer", "rescaler", "nudger", "rotater")
)
}
\arguments{
\item{x}{a 2-column matrix}

\item{rescale}{a single value or a vector with length equal to the number of columns in x}

\item{rotate}{angle in radians unless degrees is true}

\item{nudge}{a single value or a vector with length equal to the number of columns in x}

\item{center}{a single value or a vector with length equal to the number of columns in x}

\item{degrees}{if TRUE, angles are degrees instead of radians}

\item{transformations}{a vector of transformation functions}
}
\value{
a matrix
}
\description{
Do transformations in a desired order
}
\examples{

matrix(c(0,0,1,1), nrow = 2) |>
  transformer(transformations = "rotater", rotate = pi)
}
