% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.functions.R
\name{padjust}
\alias{padjust}
\alias{padjust.default}
\alias{padjust.tableby}
\alias{padjust.summary.tableby}
\title{Adjust P-values for Multiple Comparisons}
\usage{
padjust(p, method, n, ...)

\method{padjust}{default}(p, method, n, ...)

\method{padjust}{tableby}(p, method, n,
  suffix = " (adjusted for multiple comparisons)", ...)

\method{padjust}{summary.tableby}(p, method, n,
  suffix = " (adjusted for multiple comparisons)", ...)
}
\arguments{
\item{p}{An object.}

\item{method}{correction method.  Can be abbreviated.}

\item{n}{number of comparisons, must be at least \code{length(p)};
    only set this (to non-default) when you know what you are doing!}

\item{...}{Other arguments.}

\item{suffix}{A suffix to add to the footnotes indicating that the tests were adjusted.}
}
\description{
Adjust P-values for Multiple Comparisons
}
\seealso{
\code{\link[stats]{p.adjust}}, \code{\link{modpval.tableby}}, \code{\link{tests.tableby}}
}
