## Tests for tableby

context("Testing the paired output")

dat <- data.frame(
  tp = c(1, 2, 1, 2, 1, 2, 1, 2, 1, 2),
  id = c(1, 1, 2, 2, 3, 3, 4, 4, 5, 6),
  Cat = c("A", "A", "A", "B", "B", "B", "B", "A", NA, "B"),
  Fac = factor(c("A", "B", "C", "A", "B", "C", "A", "B", "C", "A")),
  Num = c(1, 2, 3, 4, 4, 3, 3, 4, 0, NA),
  Ord = ordered(c("I", "II", "II", "III", "III", "III", "I", "III", "II", "I")),
  Lgl = c(TRUE, TRUE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE),
  Dat = as.Date("2018-05-01") + c(1, 1, 2, 2, 3, 4, 5, 6, 3, 4),
  stringsAsFactors = FALSE
)

###########################################################################################################
#### Basic paired calls
###########################################################################################################

for(i in 1:3)
{
  if(i == 2) dat$id <- as.character(dat$id) else if(i == 3) dat$id <- as.factor(dat$id)
  test_that(paste0("Basic paired call; class(id) = ", class(dat$id), "; na.paired('asis')"), {
    expect_identical(
      capture.kable(summary(paired(tp ~ Cat + Fac + Num + Ord + Lgl + Dat, data = dat, id = id,
                                   signed.rank.exact = FALSE, na.action = na.paired("asis")), text = TRUE)),
      c("|             |         1 (N=5)         |         2 (N=5)         | Difference (N=4) | p value|",
        "|:------------|:-----------------------:|:-----------------------:|:----------------:|-------:|",
        "|Cat          |                         |                         |                  |   1.000|",
        "|-  N-Miss    |            1            |            0            |        0         |        |",
        "|-  A         |        2 (50.0%)        |        2 (40.0%)        |    1 (50.0%)     |        |",
        "|-  B         |        2 (50.0%)        |        3 (60.0%)        |    1 (50.0%)     |        |",
        "|Fac          |                         |                         |                  |   0.261|",
        "|-  A         |        2 (40.0%)        |        2 (40.0%)        |    2 (100.0%)    |        |",
        "|-  B         |        1 (20.0%)        |        2 (40.0%)        |    1 (100.0%)    |        |",
        "|-  C         |        2 (40.0%)        |        1 (20.0%)        |    1 (100.0%)    |        |",
        "|Num          |                         |                         |                  |   0.391|",
        "|-  N-Miss    |            0            |            1            |        0         |        |",
        "|-  Mean (SD) |      2.200 (1.643)      |      3.250 (0.957)      |  0.500 (1.000)   |        |",
        "|-  Range     |      0.000 - 4.000      |      2.000 - 4.000      |  -1.000 - 1.000  |        |",
        "|Ord          |                         |                         |                  |   0.174|",
        "|-  I         |        2 (40.0%)        |        1 (20.0%)        |    2 (100.0%)    |        |",
        "|-  II        |        2 (40.0%)        |        1 (20.0%)        |    1 (100.0%)    |        |",
        "|-  III       |        1 (20.0%)        |        3 (60.0%)        |     0 (0.0%)     |        |",
        "|Lgl          |                         |                         |                  |   1.000|",
        "|-  FALSE     |        3 (60.0%)        |        2 (40.0%)        |    2 (100.0%)    |        |",
        "|-  TRUE      |        2 (40.0%)        |        3 (60.0%)        |    1 (50.0%)     |        |",
        "|Dat          |                         |                         |                  |   0.182|",
        "|-  median    |       2018-05-04        |       2018-05-05        |      0.500       |        |",
        "|-  Range     | 2018-05-02 - 2018-05-06 | 2018-05-02 - 2018-05-07 |  0.000 - 1.000   |        |"
      )
    )
  })

  test_that(paste0("Basic paired call; class(id) = ", class(dat$id), "; na.paired('fill')"), {
    expect_identical(
      capture.kable(summary(paired(tp ~ Cat + Fac + Num + Ord + Lgl + Dat, data = dat, id = id,
                                   signed.rank.exact = FALSE, na.action = na.paired("fill")), text = TRUE)),
      c("|             |         1 (N=6)         |         2 (N=6)         | Difference (N=6) | p value|",
        "|:------------|:-----------------------:|:-----------------------:|:----------------:|-------:|",
        "|Cat          |                         |                         |                  |   1.000|",
        "|-  N-Miss    |            2            |            1            |        2         |        |",
        "|-  A         |        2 (50.0%)        |        2 (40.0%)        |    1 (50.0%)     |        |",
        "|-  B         |        2 (50.0%)        |        3 (60.0%)        |    1 (50.0%)     |        |",
        "|Fac          |                         |                         |                  |   0.261|",
        "|-  N-Miss    |            1            |            1            |        2         |        |",
        "|-  A         |        2 (40.0%)        |        2 (40.0%)        |    2 (100.0%)    |        |",
        "|-  B         |        1 (20.0%)        |        2 (40.0%)        |    1 (100.0%)    |        |",
        "|-  C         |        2 (40.0%)        |        1 (20.0%)        |    1 (100.0%)    |        |",
        "|Num          |                         |                         |                  |   0.391|",
        "|-  N-Miss    |            1            |            2            |        2         |        |",
        "|-  Mean (SD) |      2.200 (1.643)      |      3.250 (0.957)      |  0.500 (1.000)   |        |",
        "|-  Range     |      0.000 - 4.000      |      2.000 - 4.000      |  -1.000 - 1.000  |        |",
        "|Ord          |                         |                         |                  |   0.174|",
        "|-  N-Miss    |            1            |            1            |        2         |        |",
        "|-  I         |        2 (40.0%)        |        1 (20.0%)        |    2 (100.0%)    |        |",
        "|-  II        |        2 (40.0%)        |        1 (20.0%)        |    1 (100.0%)    |        |",
        "|-  III       |        1 (20.0%)        |        3 (60.0%)        |     0 (0.0%)     |        |",
        "|Lgl          |                         |                         |                  |   1.000|",
        "|-  N-Miss    |            1            |            1            |        2         |        |",
        "|-  FALSE     |        3 (60.0%)        |        2 (40.0%)        |    2 (100.0%)    |        |",
        "|-  TRUE      |        2 (40.0%)        |        3 (60.0%)        |    1 (50.0%)     |        |",
        "|Dat          |                         |                         |                  |   0.182|",
        "|-  N-Miss    |            1            |            1            |        2         |        |",
        "|-  median    |       2018-05-04        |       2018-05-05        |      0.500       |        |",
        "|-  Range     | 2018-05-02 - 2018-05-06 | 2018-05-02 - 2018-05-07 |  0.000 - 1.000   |        |"
      )
    )
  })

  test_that(paste0("Basic paired call; class(id) = ", class(dat$id), "; na.paired('in.both')"), {
    expect_identical(
      capture.kable(summary(paired(tp ~ Cat + Fac + Num + Ord + Lgl + Dat, data = dat, id = id,
                                   signed.rank.exact = FALSE, na.action = na.paired("in.both")), text = TRUE)),
      c("|             |         1 (N=4)         |         2 (N=4)         | Difference (N=4) | p value|",
        "|:------------|:-----------------------:|:-----------------------:|:----------------:|-------:|",
        "|Cat          |                         |                         |                  |   1.000|",
        "|-  A         |        2 (50.0%)        |        2 (50.0%)        |    1 (50.0%)     |        |",
        "|-  B         |        2 (50.0%)        |        2 (50.0%)        |    1 (50.0%)     |        |",
        "|Fac          |                         |                         |                  |   0.261|",
        "|-  A         |        2 (50.0%)        |        1 (25.0%)        |    2 (100.0%)    |        |",
        "|-  B         |        1 (25.0%)        |        2 (50.0%)        |    1 (100.0%)    |        |",
        "|-  C         |        1 (25.0%)        |        1 (25.0%)        |    1 (100.0%)    |        |",
        "|Num          |                         |                         |                  |   0.391|",
        "|-  Mean (SD) |      2.750 (1.258)      |      3.250 (0.957)      |  0.500 (1.000)   |        |",
        "|-  Range     |      1.000 - 4.000      |      2.000 - 4.000      |  -1.000 - 1.000  |        |",
        "|Ord          |                         |                         |                  |   0.174|",
        "|-  I         |        2 (50.0%)        |        0 (0.0%)         |    2 (100.0%)    |        |",
        "|-  II        |        1 (25.0%)        |        1 (25.0%)        |    1 (100.0%)    |        |",
        "|-  III       |        1 (25.0%)        |        3 (75.0%)        |     0 (0.0%)     |        |",
        "|Lgl          |                         |                         |                  |   1.000|",
        "|-  FALSE     |        2 (50.0%)        |        1 (25.0%)        |    2 (100.0%)    |        |",
        "|-  TRUE      |        2 (50.0%)        |        3 (75.0%)        |    1 (50.0%)     |        |",
        "|Dat          |                         |                         |                  |   0.182|",
        "|-  median    |       2018-05-03        |       2018-05-04        |      0.500       |        |",
        "|-  Range     | 2018-05-02 - 2018-05-06 | 2018-05-02 - 2018-05-07 |  0.000 - 1.000   |        |"
      )
    )
  })
}

test_that(paste0("Basic paired call; na.paired('in.both')"), {
  expect_identical(
    capture.kable(summary(paired(tp ~ Cat + Fac + Lgl, data = dat, id = id,
                                 test = FALSE, na.action = na.paired("in.both"),
                                 cat.stats = c("Nmiss", "countrowpct", "countcellpct", "rowbinomCI")), text = TRUE)),
    c("|         |       1 (N=4)        |       2 (N=4)        |   Difference (N=4)   |",
      "|:--------|:--------------------:|:--------------------:|:--------------------:|",
      "|Cat      |                      |                      |                      |",
      "|-  A     |      2 (50.0%)       |      2 (50.0%)       |      1 (50.0%)       |",
      "|-  B     |      2 (50.0%)       |      2 (50.0%)       |      1 (50.0%)       |",
      "|-  A     |      2 (25.0%)       |      2 (25.0%)       |      1 (50.0%)       |",
      "|-  B     |      2 (25.0%)       |      2 (25.0%)       |      1 (50.0%)       |",
      "|-  A     | 0.500 (0.068, 0.932) | 0.500 (0.068, 0.932) | 0.500 (0.013, 0.987) |",
      "|-  B     | 0.500 (0.068, 0.932) | 0.500 (0.068, 0.932) | 0.500 (0.013, 0.987) |",
      "|Fac      |                      |                      |                      |",
      "|-  A     |      2 (66.7%)       |      1 (33.3%)       |      2 (100.0%)      |",
      "|-  B     |      1 (33.3%)       |      2 (66.7%)       |      1 (100.0%)      |",
      "|-  C     |      1 (50.0%)       |      1 (50.0%)       |      1 (100.0%)      |",
      "|-  A     |      2 (25.0%)       |      1 (12.5%)       |      2 (100.0%)      |",
      "|-  B     |      1 (12.5%)       |      2 (25.0%)       |      1 (100.0%)      |",
      "|-  C     |      1 (12.5%)       |      1 (12.5%)       |      1 (100.0%)      |",
      "|-  A     | 0.667 (0.094, 0.992) | 0.333 (0.008, 0.906) | 1.000 (0.158, 1.000) |",
      "|-  B     | 0.333 (0.008, 0.906) | 0.667 (0.094, 0.992) | 1.000 (0.025, 1.000) |",
      "|-  C     | 0.500 (0.013, 0.987) | 0.500 (0.013, 0.987) | 1.000 (0.025, 1.000) |",
      "|Lgl      |                      |                      |                      |",
      "|-  FALSE |      2 (66.7%)       |      1 (33.3%)       |      2 (100.0%)      |",
      "|-  TRUE  |      2 (40.0%)       |      3 (60.0%)       |      1 (50.0%)       |",
      "|-  FALSE |      2 (25.0%)       |      1 (12.5%)       |      2 (100.0%)      |",
      "|-  TRUE  |      2 (25.0%)       |      3 (37.5%)       |      1 (50.0%)       |",
      "|-  FALSE | 0.667 (0.094, 0.992) | 0.333 (0.008, 0.906) | 1.000 (0.158, 1.000) |",
      "|-  TRUE  | 0.400 (0.053, 0.853) | 0.600 (0.147, 0.947) | 0.500 (0.013, 0.987) |"
    )
  )
})

dat$id[10] <- NA
dat$tp[9] <- NA
test_that("Paired with missings", {
  expect_identical(
    capture.kable(summary(paired(tp ~ Cat + Fac + Num + Ord + Lgl + Dat, data = dat, id = id, signed.rank.exact = FALSE), text = TRUE)),
    c("|             |         1 (N=4)         |         2 (N=4)         | Difference (N=4) | p value|",
      "|:------------|:-----------------------:|:-----------------------:|:----------------:|-------:|",
      "|Cat          |                         |                         |                  |   1.000|",
      "|-  A         |        2 (50.0%)        |        2 (50.0%)        |    1 (50.0%)     |        |",
      "|-  B         |        2 (50.0%)        |        2 (50.0%)        |    1 (50.0%)     |        |",
      "|Fac          |                         |                         |                  |   0.261|",
      "|-  A         |        2 (50.0%)        |        1 (25.0%)        |    2 (100.0%)    |        |",
      "|-  B         |        1 (25.0%)        |        2 (50.0%)        |    1 (100.0%)    |        |",
      "|-  C         |        1 (25.0%)        |        1 (25.0%)        |    1 (100.0%)    |        |",
      "|Num          |                         |                         |                  |   0.391|",
      "|-  Mean (SD) |      2.750 (1.258)      |      3.250 (0.957)      |  0.500 (1.000)   |        |",
      "|-  Range     |      1.000 - 4.000      |      2.000 - 4.000      |  -1.000 - 1.000  |        |",
      "|Ord          |                         |                         |                  |   0.174|",
      "|-  I         |        2 (50.0%)        |        0 (0.0%)         |    2 (100.0%)    |        |",
      "|-  II        |        1 (25.0%)        |        1 (25.0%)        |    1 (100.0%)    |        |",
      "|-  III       |        1 (25.0%)        |        3 (75.0%)        |     0 (0.0%)     |        |",
      "|Lgl          |                         |                         |                  |   1.000|",
      "|-  FALSE     |        2 (50.0%)        |        1 (25.0%)        |    2 (100.0%)    |        |",
      "|-  TRUE      |        2 (50.0%)        |        3 (75.0%)        |    1 (50.0%)     |        |",
      "|Dat          |                         |                         |                  |   0.182|",
      "|-  median    |       2018-05-03        |       2018-05-04        |      0.500       |        |",
      "|-  Range     | 2018-05-02 - 2018-05-06 | 2018-05-02 - 2018-05-07 |  0.000 - 1.000   |        |"
    )
  )
})

test_that("09/07/2018: specifying different digits (#107) and cat.simplify (#134)", {
  expect_identical(
    capture.kable(summary(paired(tp ~ mcnemar(Cat, digits.count = 1, digits.pct = 0, cat.simplify = TRUE) + paired.t(Num, digits = 1),
                                 data = dat, id = id), text = TRUE)),
    c("|             |  1 (N=4)  |  2 (N=4)  | Difference (N=4) | p value|",
      "|:------------|:---------:|:---------:|:----------------:|-------:|",
      "|Cat          | 2.0 (50%) | 2.0 (50%) |    1.0 (50%)     |   1.000|",
      "|Num          |           |           |                  |   0.391|",
      "|-  Mean (SD) | 2.8 (1.3) | 3.2 (1.0) |    0.5 (1.0)     |        |",
      "|-  Range     | 1.0 - 4.0 | 2.0 - 4.0 |    -1.0 - 1.0    |        |"
    )
  )
})

dat$tp <- replace(as.character(dat$tp), dat$tp == "2", "")
test_that("08/23/2018: empty string in by-variable (#121)",
          expect_warning(summary(paired(tp ~ Cat, id = id, data = dat, signed.rank.exact = FALSE)), "Empty"))
