# This is a poor mans implementation which mines all rules and
# then filters the rules which do not stam from the itemsets
  

setMethod("ruleInduction",  signature(x = "itemsets"),
function(x, transactions, verbose = FALSE) {
 
  # find minimal support and mine all rules
  minSupport <-  min(quality(x)$support)
  rules <- apriori(transactions,  parameter = list(support = minSupport,
  	target = "rules"), control = list(verbose = verbose))
  
  # find rules which were generated by the itemsets
  isetsSize <-  size(x)
  isets <- as(items(x), "dgCMatrix")
  generatingIsets <- as(as(lhs(rules)@data, "dgTMatrix") + 
	as(rhs(rules)@data, "dgTMatrix"), "dgCMatrix")

 
  # filter rules which do not match a itemset
  if (verbose) cat("\n filter rules: ")
  takeSet <- c ()
  for (i in 1 : dim(generatingIsets)[2]) {
     if (any(colSums(generatingIsets[, i] * isets) == isetsSize)) {
     takeSet <- c(takeSet, i)
     }
     if (verbose) cat(i, ", ", sep = "")
  }

  if (verbose) cat("done.\n")
  
  # return the rules
  rules[takeSet]
})




