% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{merge}
\alias{merge,itemMatrix-method}
\alias{merge,transactions-method}
\title{Adding Items to Data}
\usage{
merge(x, y, ...)

\S4method{merge}{itemMatrix}(x, y, ...)

\S4method{merge}{transactions}(x, y, ...)
}
\arguments{
\item{x}{an object of class \link{itemMatrix} or \link{transactions}.}

\item{y}{an object of the same class as \code{x} (or something which can be coerced
to that class).}

\item{...}{further arguments; unused.}
}
\value{
Returns a new object of the same class as \code{x} with the items in \code{y}
added.
}
\description{
Provides the generic function \code{merge()} and the methods for \link{itemMatrix}
and \link{transactions} to add new items to existing data.
}
\examples{
data("Groceries")

## create a random item as a matrix
randomItem <- sample(c(TRUE, FALSE), size = length(Groceries),replace = TRUE)
randomItem <- as.matrix(randomItem)
colnames(randomItem) <- "random item"
head(randomItem, 3)

## add the random item to Groceries
g2 <- merge(Groceries, randomItem)
nitems(Groceries)
nitems(g2)
inspect(head(g2, 3))

}
\seealso{
Other preprocessing: 
\code{\link{discretize}()},
\code{\link{hierarchy}},
\code{\link{itemCoding}},
\code{\link{sample}()}

Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{crossTable}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequency}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\concept{preprocessing}
\keyword{manip}
