% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classFrequency.R
\name{CBA_helpers}
\alias{CBA_helpers}
\alias{response}
\alias{classFrequency}
\alias{majorityClass}
\alias{transactionCoverage}
\alias{uncoveredClassExamples}
\alias{uncoveredMajorityClass}
\title{Helper Functions For Dealing with Classes}
\usage{
response(formula, x)

classFrequency(formula, x, type = "relative")

majorityClass(formula, transactions)

transactionCoverage(transactions, rules)

uncoveredClassExamples(formula, transactions, rules)

uncoveredMajorityClass(formula, transactions, rules)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted.}

\item{x, transactions}{An object of class \code{\link[arules]{transactions}}
or \code{\link[arules]{rules}}.}

\item{type}{\code{"relative"} or \code{"absolute"} to return proportions or
absolute counts.}

\item{rules}{A set of \code{\link[arules]{rules}}.}
}
\value{
\code{response} returns the response label as a factor.

\code{classFrequency} returns the item frequency for each class label as a
vector.

\code{majorityClass} returns the most frequent class label in the
transactions.
}
\description{
Helper functions to extract the response from transactions or rules, determine the
class frequency, majority class, transaction coverage and the
uncovered examples per class.
}
\examples{

data("iris")

iris.disc <- discretizeDF.supervised(Species ~ ., iris)
iris.trans <- as(iris.disc, "transactions")
inspect(head(iris.trans, n = 2))

# convert the class items back to a class label
response(Species ~ ., head(iris.trans, n = 2))

# Class distribution. The iris dataset is perfectly balanced.
classFrequency(Species ~ ., iris.trans)

# Majority Class
# (Note: since all class frequencies for iris are the same, the first one is returned)
majorityClass(Species ~ ., iris.trans)

# Use for CARs
cars <- mineCARs(Species ~ ., iris.trans, parameter = list(support = 0.3))

# Number of rules for each class
classFrequency(Species ~ ., cars, type = "absolute")

# conclusion (item in the RHS) of the rule as a class label
response(Species ~ ., cars)

# How many rules (using the first three rules) cover each transactions?
transactionCoverage(iris.trans, cars[1:3])

# Number of transactions per class not covered by the first three rules
uncoveredClassExamples(Species ~ ., iris.trans, cars[1:3])

# Majority class of the uncovered examples
uncoveredMajorityClass(Species ~ ., iris.trans, cars[1:3])
}
\seealso{
\code{\link[arules]{itemFrequency}}, \code{\link[arules]{rules}},
\code{\link[arules]{transactions}}.
}
\author{
Michael Hahsler
}
