/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JTextArea;

public class TotalSupportTree
extends AssocRuleMining {
    protected TtreeNode[] startTtreeRef;
    protected int[] serializationArray;
    protected int serializationRef = 0;
    protected final int MAX_NUM_FREQUENT_SETS = 500000;
    protected boolean nextLevelExists = true;
    protected int numLevelsInTtree = 0;
    private int maxTtreeGraphNodes = 0;
    protected boolean outputTtreeStatsFlag = false;
    protected boolean outputTtreeFlag = false;
    protected boolean outputTtreeGraphFlag = false;
    protected long numUpdates = 0L;
    protected String duration = null;

    public TotalSupportTree(String[] stringArray) {
        super(stringArray);
    }

    public TotalSupportTree(AssocRuleMining assocRuleMining) {
        super(assocRuleMining);
        this.numRows = assocRuleMining.numRows;
        this.numCols = assocRuleMining.numCols;
        this.support = assocRuleMining.support;
        this.confidence = assocRuleMining.confidence;
        this.dataArray = assocRuleMining.dataArray;
        this.minSupport = assocRuleMining.minSupport;
        this.numOneItemSets = assocRuleMining.numOneItemSets;
        this.conversionArray = assocRuleMining.conversionArray;
        this.reconversionArray = assocRuleMining.reconversionArray;
    }

    public TotalSupportTree() {
    }

    public void createTotalSupportTree() {
        System.out.println("Apriori-T with X-CheckinnMinimum support threshold = " + this.twoDecPlaces(this.support) + "% (" + this.twoDecPlaces(this.minSupport) + " records)");
        if (this.numOneItemSets == 0) {
            return;
        }
        this.startTtreeRef = null;
        this.numFrequentSets = 0;
        this.numUpdates = 0L;
        TtreeNode.setNumberOfNodesFieldToZero();
        this.contCreateTtree();
        if (this.outputTtreeStatsFlag) {
            this.outputTtreeStats();
        }
        if (this.outputTtreeFlag) {
            this.outputTtree();
        }
    }

    public void createTotalSupportTree(JTextArea jTextArea) {
        jTextArea.append("Apriori-T with X-CcheckinnMinimum support threshold = " + this.twoDecPlaces(this.support) + "% (" + this.twoDecPlaces(this.minSupport) + " records)\n");
        if (this.numOneItemSets == 0) {
            return;
        }
        this.startTtreeRef = null;
        this.numFrequentSets = 0;
        this.numUpdates = 0L;
        TtreeNode.setNumberOfNodesFieldToZero();
        this.contCreateTtree(jTextArea);
        if (this.outputTtreeStatsFlag) {
            this.outputTtreeStats(jTextArea);
        }
        if (this.outputTtreeFlag) {
            this.outputTtree(jTextArea);
        }
    }

    protected void contCreateTtree() {
        this.createTtreeTopLevel();
        this.generateLevel2();
        this.createTtreeLevelN();
    }

    protected void contCreateTtree(JTextArea jTextArea) {
        this.createTtreeTopLevel();
        this.generateLevel2();
        this.createTtreeLevelN(jTextArea);
    }

    protected void createTtreeTopLevel() {
        this.startTtreeRef = new TtreeNode[this.numOneItemSets + 1];
        for (int i = 1; i <= this.numOneItemSets; ++i) {
            this.startTtreeRef[i] = new TtreeNode();
        }
        this.createTtreeTopLevel2();
        this.pruneLevelN(this.startTtreeRef, 1);
    }

    protected void createTtreeTopLevel2() {
        this.numLevelsInTtree = 1;
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            for (int j = 0; j < this.dataArray[i].length; ++j) {
                ++this.startTtreeRef[this.dataArray[i][j]].support;
                ++this.numUpdates;
            }
        }
    }

    protected void createTtreeLevelN() {
        int n = 2;
        while (this.nextLevelExists) {
            this.addSupportToTtreeLevelN(n);
            this.pruneLevelN(this.startTtreeRef, n);
            if (this.numFrequentSets > 500000) {
                System.out.println("Number of frequent sets (" + this.numFrequentSets + ") generted so far exceeds limit of " + 500000 + ", generation process stopped!");
                break;
            }
            this.nextLevelExists = false;
            this.generateLevelN(this.startTtreeRef, n, null);
            ++n;
        }
        this.numLevelsInTtree = n - 1;
    }

    protected void createTtreeLevelN(JTextArea jTextArea) {
        int n = 2;
        while (this.nextLevelExists) {
            this.addSupportToTtreeLevelN(n);
            this.pruneLevelN(this.startTtreeRef, n);
            this.nextLevelExists = false;
            this.generateLevelN(this.startTtreeRef, n, null);
            ++n;
        }
        this.numLevelsInTtree = n - 1;
        jTextArea.append("Levels in T-tree = " + this.numLevelsInTtree + "\n");
    }

    public void createTotalSupportTreeNB() {
    }

    public void createTotalSupportTreeNB(JTextArea jTextArea) {
    }

    protected void addSupportToTtreeLevelN(int n) {
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (this.dataArray[i] == null) continue;
            this.addSupportToTtree(this.startTtreeRef, n, this.dataArray[i].length, this.dataArray[i]);
        }
    }

    protected void addSupportToTtree(TtreeNode[] ttreeNodeArray, int n, int n2, short[] sArray) {
        if (n == 1) {
            for (int i = 0; i < n2; ++i) {
                if (ttreeNodeArray[sArray[i]] == null) continue;
                ++ttreeNodeArray[sArray[i]].support;
                ++this.numUpdates;
            }
        } else {
            for (int i = n - 1; i < n2; ++i) {
                if (ttreeNodeArray[sArray[i]] == null || ttreeNodeArray[sArray[i]].childRef == null) continue;
                this.addSupportToTtree(ttreeNodeArray[sArray[i]].childRef, n - 1, i, sArray);
            }
        }
    }

    protected boolean pruneLevelN(TtreeNode[] ttreeNodeArray, int n) {
        int n2 = ttreeNodeArray.length;
        if (n == 1) {
            boolean bl = true;
            for (int i = 1; i < n2; ++i) {
                if (ttreeNodeArray[i] == null) continue;
                if ((double)ttreeNodeArray[i].support < this.minSupport) {
                    ttreeNodeArray[i] = null;
                    continue;
                }
                ++this.numFrequentSets;
                bl = false;
            }
            return bl;
        }
        for (int i = n; i < n2; ++i) {
            if (ttreeNodeArray[i] == null || ttreeNodeArray[i].childRef == null || !this.pruneLevelN(ttreeNodeArray[i].childRef, n - 1)) continue;
            ttreeNodeArray[i].childRef = null;
        }
        return false;
    }

    protected void generateLevel2() {
        this.nextLevelExists = false;
        for (int i = 2; i < this.startTtreeRef.length; ++i) {
            if (this.startTtreeRef[i] == null) continue;
            this.generateNextLevel(this.startTtreeRef, i, this.realloc2(null, (short)i));
        }
    }

    protected void generateLevelN(TtreeNode[] ttreeNodeArray, int n, short[] sArray) {
        int n2 = ttreeNodeArray.length;
        if (n == 1) {
            for (int i = 2; i < n2; ++i) {
                if (ttreeNodeArray[i] == null) continue;
                this.generateNextLevel(ttreeNodeArray, i, this.realloc2(sArray, (short)i));
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (ttreeNodeArray[i] == null || ttreeNodeArray[i].childRef == null) continue;
                this.generateLevelN(ttreeNodeArray[i].childRef, n - 1, this.realloc2(sArray, (short)i));
            }
        }
    }

    protected void generateNextLevel(TtreeNode[] ttreeNodeArray, int n, short[] sArray) {
        ttreeNodeArray[n].childRef = new TtreeNode[n];
        TtreeNode ttreeNode = ttreeNodeArray[n];
        for (int i = 1; i < n; ++i) {
            if (ttreeNodeArray[i] == null) continue;
            short[] sArray2 = this.realloc2(sArray, (short)i);
            if (this.testCombinations(sArray2)) {
                ttreeNode.childRef[i] = new TtreeNode();
                this.nextLevelExists = true;
                continue;
            }
            ttreeNode.childRef[i] = null;
        }
    }

    protected boolean testCombinations(short[] sArray) {
        if (sArray.length < 3) {
            return true;
        }
        short[] sArray2 = new short[]{sArray[1], sArray[0]};
        int n = sArray.length - 2;
        short[] sArray3 = this.removeFirstNelements(sArray, 2);
        return this.combinations(null, 0, 2, sArray2, sArray3);
    }

    private boolean combinations(short[] sArray, int n, int n2, short[] sArray2, short[] sArray3) {
        if (n2 > sArray3.length) {
            short[] sArray4 = this.append(sArray, sArray2);
            return this.findItemSetInTtree(sArray4);
        }
        for (int i = n; i < n2; ++i) {
            short[] sArray5 = this.realloc2(sArray, sArray3[i]);
            if (this.combinations(sArray5, i + 1, n2 + 1, sArray2, sArray3)) continue;
            return false;
        }
        return true;
    }

    public void addToTtree(short[] sArray, int n) {
        int n2 = sArray.length - 1;
        this.startTtreeRef = this.addToTtree(this.startTtreeRef, this.numOneItemSets + 1, n2, sArray, n);
    }

    protected TtreeNode[] addToTtree(TtreeNode[] ttreeNodeArray, int n, int n2, short[] sArray, int n3) {
        int n4;
        if (ttreeNodeArray == null) {
            ttreeNodeArray = new TtreeNode[n];
            for (n4 = 1; n4 < ttreeNodeArray.length; ++n4) {
                ttreeNodeArray[n4] = null;
            }
        }
        if (ttreeNodeArray[n4 = sArray[n2]] == null) {
            ttreeNodeArray[n4] = new TtreeNode();
        }
        if (n2 == 0) {
            ttreeNodeArray[n4].support += n3;
            return ttreeNodeArray;
        }
        ttreeNodeArray[n4].childRef = this.addToTtree(ttreeNodeArray[n4].childRef, n4, n2 - 1, sArray, n3);
        return ttreeNodeArray;
    }

    protected boolean findItemSetInTtree(short[] sArray) {
        if (this.startTtreeRef[sArray[0]] != null) {
            int n = sArray.length - 1;
            if (n == 0) {
                return true;
            }
            if (this.startTtreeRef[sArray[0]].childRef != null) {
                return this.findItemSetInTtree2(sArray, 1, n, this.startTtreeRef[sArray[0]].childRef);
            }
            return false;
        }
        return false;
    }

    protected boolean findItemSetInTtree2(short[] sArray, int n, int n2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray[sArray[n]] != null) {
            if (n == n2) {
                return true;
            }
            if (ttreeNodeArray[sArray[n]].childRef != null) {
                return this.findItemSetInTtree2(sArray, n + 1, n2, ttreeNodeArray[sArray[n]].childRef);
            }
            return false;
        }
        return false;
    }

    protected int getSupportForItemSetInTtree(short[] sArray) {
        int n = sArray.length - 1;
        if (sArray[n] >= this.startTtreeRef.length) {
            return 0;
        }
        if (this.startTtreeRef[sArray[n]] != null) {
            if (n == 0) {
                return this.startTtreeRef[sArray[0]].support;
            }
            TtreeNode[] ttreeNodeArray = this.startTtreeRef[sArray[n]].childRef;
            if (ttreeNodeArray != null) {
                return this.getSupForIsetInTtree2(sArray, n - 1, ttreeNodeArray);
            }
            return 0;
        }
        return 0;
    }

    private int getSupForIsetInTtree2(short[] sArray, int n, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray[sArray[n]] != null) {
            if (n == 0) {
                return ttreeNodeArray[sArray[0]].support;
            }
            if (ttreeNodeArray[sArray[n]].childRef != null) {
                return this.getSupForIsetInTtree2(sArray, n - 1, ttreeNodeArray[sArray[n]].childRef);
            }
            return 0;
        }
        return 0;
    }

    protected void setChildRefToNull(short[] sArray) {
        if (this.startTtreeRef[sArray[0]] != null) {
            int n = sArray.length - 1;
            if (n == 0) {
                this.startTtreeRef[sArray[0]] = null;
            } else if (this.startTtreeRef[sArray[0]].childRef != null) {
                this.setChildRefToNull(sArray, 1, n, this.startTtreeRef[sArray[0]].childRef);
            }
        }
    }

    private void setChildRefToNull(short[] sArray, int n, int n2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray[sArray[n]] != null) {
            if (n == n2) {
                ttreeNodeArray[sArray[n]] = null;
            } else if (ttreeNodeArray[sArray[n]].childRef != null) {
                this.setChildRefToNull(sArray, n + 1, n2, ttreeNodeArray[sArray[n]].childRef);
            }
        }
    }

    protected void serializeTteeNoSupValues() {
        int n = 0;
        int n2 = 0;
        int n3 = this.countNumberOfTtreeNodes() * 3;
        this.serializationArray = new int[n3];
        this.serializationRef = 0;
        System.out.println("Serialized Ttree (No sup values) = " + n3 * 4 + " (bytes)");
        for (int i = 1; i < this.startTtreeRef.length; ++i) {
            if (this.startTtreeRef[i] == null) continue;
            n = this.addToSerializationArray(i);
            if (n != 0) {
                this.serializationArray[n2 + 2] = n;
            }
            n2 = n;
            this.serializationArray[n2 + 1] = this.serializeTteeNoSupValues(this.startTtreeRef[i].childRef);
        }
    }

    private int serializeTteeNoSupValues(TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return -1;
        }
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] == null) continue;
            n2 = this.addToSerializationArray(i);
            if (n == -1) {
                n = n2;
            } else {
                this.serializationArray[n3 + 2] = n2;
            }
            n3 = n2;
            this.serializationArray[n3 + 1] = this.serializeTteeNoSupValues(ttreeNodeArray[i].childRef);
        }
        return n;
    }

    private int addToSerializationArray(int n) {
        int n2 = this.serializationRef;
        this.serializationArray[this.serializationRef] = n;
        this.serializationArray[this.serializationRef + 1] = -1;
        this.serializationArray[this.serializationRef + 2] = -1;
        this.serializationRef += 3;
        return n2;
    }

    protected void serializeTtee() {
        int n = 0;
        int n2 = 0;
        int n3 = this.countNumberOfTtreeNodes() * 4;
        this.serializationArray = new int[n3];
        this.serializationRef = 0;
        System.out.println("Serialized Ttree = " + n3 * 4 + " (bytes)");
        for (int i = 1; i < this.startTtreeRef.length; ++i) {
            if (this.startTtreeRef[i] == null) continue;
            n = this.addToSerializationArray(i, this.startTtreeRef[i].support);
            if (n != 0) {
                this.serializationArray[n2 + 3] = n;
            }
            n2 = n;
            this.serializationArray[n2 + 2] = this.serializeTtee(this.startTtreeRef[i].childRef);
        }
    }

    private int serializeTtee(TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return -1;
        }
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] == null) continue;
            n2 = this.addToSerializationArray(i, ttreeNodeArray[i].support);
            if (n == -1) {
                n = n2;
            } else {
                this.serializationArray[n3 + 3] = n2;
            }
            n3 = n2;
            this.serializationArray[n3 + 2] = this.serializeTtee(ttreeNodeArray[i].childRef);
        }
        return n;
    }

    private int addToSerializationArray(int n, int n2) {
        int n3 = this.serializationRef;
        this.serializationArray[this.serializationRef] = n;
        this.serializationArray[this.serializationRef + 1] = n2;
        this.serializationArray[this.serializationRef + 2] = -1;
        this.serializationArray[this.serializationRef + 3] = -1;
        this.serializationRef += 4;
        return n3;
    }

    protected void serializeTteeBranches(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.countNumTtreeNodesInNbranches(n, n2) * 4;
        this.serializationArray = new int[n5];
        System.out.println("Serialized Ttree branch = " + n5 * 4 + " (bytes)");
        this.serializationRef = 0;
        for (int i = n; i <= n2; ++i) {
            if (this.startTtreeRef[i] == null) continue;
            n3 = this.addToSerializationArray(i, this.startTtreeRef[i].support);
            if (n3 != 0) {
                this.serializationArray[n4 + 3] = n3;
            }
            n4 = n3;
            this.serializationArray[n4 + 2] = this.serializeTtee(this.startTtreeRef[i].childRef);
        }
    }

    protected void serializeTteeLevelN(int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.countNumTtreeNodesLevelN(0, n, this.startTtreeRef) * (n + 1);
        this.serializationArray = new int[n2];
        System.out.println("Serialized Ttree level = " + n2 * 4 + " (bytes)");
        this.serializationRef = 0;
        this.serializeTteeLevelN(n, this.startTtreeRef, null);
    }

    private void serializeTteeLevelN(int n, TtreeNode[] ttreeNodeArray, short[] sArray) {
        if (ttreeNodeArray == null) {
            return;
        }
        if (n == 1) {
            for (int i = 1; i < ttreeNodeArray.length; ++i) {
                if (ttreeNodeArray[i] == null || ttreeNodeArray[i].support <= 0) continue;
                this.addToLevelNserializationArray(sArray, i, ttreeNodeArray[i].support);
            }
        } else {
            for (int i = 1; i < ttreeNodeArray.length; ++i) {
                if (ttreeNodeArray[i] == null) continue;
                this.serializeTteeLevelN(n - 1, ttreeNodeArray[i].childRef, this.realloc1(sArray, (short)i));
            }
        }
    }

    private void addToLevelNserializationArray(short[] sArray, int n, int n2) {
        if (sArray != null) {
            for (int i = 0; i < sArray.length; ++i) {
                this.serializationArray[this.serializationRef] = sArray[i];
                ++this.serializationRef;
            }
        }
        this.serializationArray[this.serializationRef] = n;
        ++this.serializationRef;
        this.serializationArray[this.serializationRef] = n2;
        ++this.serializationRef;
    }

    protected void mergeSerializationAndTtree() {
        int n = 0;
        while (n != -1) {
            int n2 = this.serializationArray[n];
            if (this.startTtreeRef[n2] == null) {
                this.startTtreeRef[n2] = new TtreeNode(this.serializationArray[n + 1]);
                ++this.numUpdates;
            } else {
                this.startTtreeRef[n2].support += this.serializationArray[n + 1];
                ++this.numUpdates;
            }
            this.startTtreeRef[n2].childRef = this.mergeSerializationAndTtree(this.startTtreeRef[n2].childRef, n2, this.serializationArray[n + 2]);
            n = this.serializationArray[n + 3];
        }
    }

    private TtreeNode[] mergeSerializationAndTtree(TtreeNode[] ttreeNodeArray, int n, int n2) {
        if (n2 == -1) {
            return ttreeNodeArray;
        }
        if (ttreeNodeArray == null) {
            ttreeNodeArray = new TtreeNode[n];
        }
        while (n2 != -1) {
            int n3 = this.serializationArray[n2];
            if (ttreeNodeArray[n3] == null) {
                ttreeNodeArray[n3] = new TtreeNode(this.serializationArray[n2 + 1]);
                ++this.numUpdates;
            } else {
                ttreeNodeArray[n3].support += this.serializationArray[n2 + 1];
                ++this.numUpdates;
            }
            ttreeNodeArray[n3].childRef = this.mergeSerializationAndTtree(ttreeNodeArray[n3].childRef, n3, this.serializationArray[n2 + 2]);
            n2 = this.serializationArray[n2 + 3];
        }
        return ttreeNodeArray;
    }

    protected void serialization2TtreeNoSupValues() {
        int n = 0;
        this.startTtreeRef = new TtreeNode[this.numOneItemSets + 1];
        while (n != -1) {
            int n2 = this.serializationArray[n];
            if (this.startTtreeRef[n2] == null) {
                this.startTtreeRef[n2] = new TtreeNode(0);
            }
            this.startTtreeRef[n2].childRef = this.serialization2TtreeNoSupValue(this.startTtreeRef[n2].childRef, n2, this.serializationArray[n + 1]);
            n = this.serializationArray[n + 2];
        }
    }

    private TtreeNode[] serialization2TtreeNoSupValue(TtreeNode[] ttreeNodeArray, int n, int n2) {
        if (n2 == -1) {
            return ttreeNodeArray;
        }
        if (ttreeNodeArray == null) {
            ttreeNodeArray = new TtreeNode[n];
        }
        while (n2 != -1) {
            int n3 = this.serializationArray[n2];
            if (ttreeNodeArray[n3] == null) {
                ttreeNodeArray[n3] = new TtreeNode(0);
                ++this.numUpdates;
            }
            ttreeNodeArray[n3].childRef = this.serialization2TtreeNoSupValue(ttreeNodeArray[n3].childRef, n3, this.serializationArray[n2 + 1]);
            n2 = this.serializationArray[n2 + 2];
        }
        return ttreeNodeArray;
    }

    public void generateARs() {
        System.out.println("GENERATE ARs (support-confidence framework):\n--------------------------------------------");
        this.supConfFworkFlag = true;
        this.startRulelist = null;
        this.generateARs2();
        this.supConfFworkFlag = false;
        this.numberRulesInBinTree();
    }

    public void generateARsLift() {
        System.out.println("GENERATE ARs (support-lift framework):\n--------------------------------------");
        this.supLiftFworkFlag = true;
        this.startRulelist = null;
        this.generateARs2();
        this.supLiftFworkFlag = false;
        this.numberRulesInBinTree();
    }

    public void generateARs(JTextArea jTextArea) {
        this.supConfFworkFlag = true;
        this.startRulelist = null;
        this.startRulelist = null;
        this.generateARs2();
        this.supConfFworkFlag = false;
        this.numberRulesInBinTree();
    }

    public void generateARsLift(JTextArea jTextArea) {
        this.supLiftFworkFlag = true;
        this.startRulelist = null;
        this.generateARs2();
        this.supLiftFworkFlag = false;
        this.numberRulesInBinTree();
    }

    protected void generateARs2() {
        for (short s = 1; s <= this.numOneItemSets; s = (short)((short)(s + 1))) {
            if (this.startTtreeRef[s] == null || !((double)this.startTtreeRef[s].support >= this.minSupport)) continue;
            short[] sArray = new short[]{s};
            this.generateARs(sArray, s, this.startTtreeRef[s].childRef);
        }
    }

    protected void generateARs(short[] sArray, int n, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            if (ttreeNodeArray[i] == null || !((double)ttreeNodeArray[i].support >= this.minSupport)) continue;
            short[] sArray2 = this.realloc2(sArray, (short)i);
            this.generateARsFromItemset(sArray2, ttreeNodeArray[i].support);
            this.generateARs(sArray2, i, ttreeNodeArray[i].childRef);
        }
    }

    protected void generateARsFromItemset(short[] sArray, double d) {
        if (sArray == null) {
            return;
        }
        int n = 0;
        short[] sArray2 = null;
        this.generateARsFromItemset(sArray, n, sArray2, d);
    }

    private void generateARsFromItemset(short[] sArray, int n, short[] sArray2, double d) {
        for (int i = n; i < sArray.length; ++i) {
            short[] sArray3 = this.realloc1(sArray2, sArray[i]);
            short[] sArray4 = this.complement(sArray3, sArray);
            if (sArray4 != null) {
                if (this.supConfFworkFlag) {
                    this.testRuleSupConfFwork(sArray3, sArray4, d);
                } else if (this.supLiftFworkFlag) {
                    this.testRuleSupLiftFwork(sArray3, sArray4, d);
                }
            }
            this.generateARsFromItemset(sArray, i + 1, this.copyItemSet(sArray3), d);
        }
    }

    protected void testRuleSupConfFwork(short[] sArray, short[] sArray2, double d) {
        double d2 = this.getConfidence(sArray, d);
        if (d2 >= this.confidence) {
            this.insertRuleIntoRulelist(sArray, sArray2, d2, d);
        }
    }

    protected void testRuleSupLiftFwork(short[] sArray, short[] sArray2, double d) {
        double d2 = this.getSupportForItemSetInTtree(sArray);
        double d3 = this.getSupportForItemSetInTtree(sArray2);
        double d4 = 100.0 * (d / d2);
        double d5 = d4 / (d3 = 100.0 * d3 / (double)this.numRows);
        if (d5 > 1.0) {
            this.insertRuleIntoRulelist(sArray, sArray2, d5, 0.0);
        }
    }

    public void setLevelsInTtree(int n) {
        this.numLevelsInTtree = n;
    }

    public void setNumUpdates(long l) {
        this.numUpdates = l;
    }

    public void setOutputTtreeStatsFlag(boolean bl) {
        this.outputTtreeStatsFlag = bl;
    }

    public void setOutputTtreeFlag(boolean bl) {
        this.outputTtreeFlag = bl;
    }

    public void setOutputTtreeGraphFlag(boolean bl, int n) {
        this.outputTtreeGraphFlag = bl;
        this.maxTtreeGraphNodes = n;
    }

    protected double getConfidence(short[] sArray, double d) {
        double d2 = this.getSupportForItemSetInTtree(sArray);
        double d3 = d / d2 * 10000.0;
        int n = (int)d3;
        d3 = (double)n / 100.0;
        return d3;
    }

    protected double getConfidence(double d, double d2) {
        double d3 = d2 / d * 10000.0;
        int n = (int)d3;
        d3 = (double)n / 100.0;
        return d3;
    }

    public TtreeNode[] getStartOfTtree() {
        return this.startTtreeRef;
    }

    public int getNumFreqSets() {
        return this.numFrequentSets;
    }

    public int getNnumFreqOneItemSets() {
        return this.numOneItemSets;
    }

    public int getMaxNumFrequentSets() {
        return 500000;
    }

    public double getMinSupport() {
        return this.minSupport;
    }

    public int getLevelsInTtree() {
        return this.numLevelsInTtree;
    }

    public long getNumUpdates() {
        return this.numUpdates;
    }

    public void copyTtree(TtreeNode[] ttreeNodeArray) {
        this.startTtreeRef = new TtreeNode[ttreeNodeArray.length];
        for (int i = 0; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] != null) {
                this.startTtreeRef[i] = new TtreeNode(ttreeNodeArray[i]);
                if (ttreeNodeArray[i].childRef == null) continue;
                this.startTtreeRef[i].childRef = this.copyTtree2(ttreeNodeArray[i].childRef);
                continue;
            }
            this.startTtreeRef[i] = null;
        }
    }

    protected TtreeNode[] copyTtree2(TtreeNode[] ttreeNodeArray) {
        TtreeNode[] ttreeNodeArray2 = new TtreeNode[ttreeNodeArray.length];
        for (int i = 0; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] != null) {
                ttreeNodeArray2[i] = new TtreeNode(ttreeNodeArray[i]);
                if (ttreeNodeArray[i].childRef == null) continue;
                ttreeNodeArray2[i].childRef = this.copyTtree2(ttreeNodeArray[i].childRef);
                continue;
            }
            ttreeNodeArray2[i] = null;
        }
        return ttreeNodeArray2;
    }

    public void setNumOneItemSets() {
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    public void setSupportReductionValue(double d) {
    }

    public double getSupportReductionValue() {
        return 0.1;
    }

    protected int countNumberOfTtreeNodes() {
        int n = 0;
        for (int i = 1; i < this.startTtreeRef.length; ++i) {
            if (this.startTtreeRef[i] == null) continue;
            ++n;
            n = this.countNumberOfTtreeNodes(n, this.startTtreeRef[i].childRef);
        }
        return n;
    }

    private int countNumTtreeNodesInNbranches(int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (this.startTtreeRef[i] == null) continue;
            ++n3;
            n3 = this.countNumberOfTtreeNodes(n3, this.startTtreeRef[i].childRef);
        }
        return n3;
    }

    private int countNumberOfTtreeNodes(int n, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return n;
        }
        for (int i = 1; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] == null) continue;
            ++n;
            n = this.countNumberOfTtreeNodes(n, ttreeNodeArray[i].childRef);
        }
        return n;
    }

    private int countNumTtreeNodesLevelN(int n, int n2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return n;
        }
        if (n2 == 1) {
            for (int i = 1; i < ttreeNodeArray.length; ++i) {
                if (ttreeNodeArray[i] == null || ttreeNodeArray[i].support <= 0) continue;
                ++n;
            }
        } else {
            for (int i = 1; i < ttreeNodeArray.length; ++i) {
                if (ttreeNodeArray[i] == null) continue;
                n = this.countNumTtreeNodesLevelN(n, n2 - 1, ttreeNodeArray[i].childRef);
            }
        }
        return n;
    }

    protected void calcNumLevelsInTtree() {
        if (this.startTtreeRef == null) {
            this.numLevelsInTtree = 0;
        }
        this.numLevelsInTtree = this.calcNumLevelsInTtree(this.startTtreeRef);
    }

    protected int calcNumLevelsInTtree(TtreeNode[] ttreeNodeArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] == null || n >= (n2 = ttreeNodeArray[i].childRef != null ? 1 + this.calcNumLevelsInTtree(ttreeNodeArray[i].childRef) : 1)) continue;
            n = n2;
        }
        return n;
    }

    protected void calcNumFrequentSets() {
        if (this.startTtreeRef == null) {
            this.numFrequentSets = 0;
        }
        this.calcNumFrequentSets(this.startTtreeRef);
    }

    protected void calcNumFrequentSets(TtreeNode[] ttreeNodeArray) {
        for (int i = 1; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] == null) continue;
            if ((double)ttreeNodeArray[i].support > this.minSupport) {
                ++this.numFrequentSets;
            }
            if (ttreeNodeArray[i].childRef == null) continue;
            this.calcNumFrequentSets(ttreeNodeArray[i].childRef);
        }
    }

    public void outputTtree() {
        int n = 1;
        System.out.println("T-TREE:\n-------");
        System.out.println("Format: [N] {I} = S, where N is the node number, I is the item set and S the support.");
        if (this.startTtreeRef == null) {
            System.out.println("Ttree empty!");
            return;
        }
        for (short s = 1; s < this.startTtreeRef.length; s = (short)((short)(s + 1))) {
            if (this.startTtreeRef[s] == null) continue;
            short[] sArray = new short[]{s};
            System.out.print("[" + n + "]");
            this.outputItemSet(sArray);
            System.out.println("= " + this.startTtreeRef[s].support);
            this.outputTtree(new Integer(n).toString(), sArray, this.startTtreeRef[s].childRef);
            ++n;
        }
        System.out.println("--------------------------------");
    }

    private void outputTtree(String string, short[] sArray, TtreeNode[] ttreeNodeArray) {
        int n = 1;
        string = string + ".";
        if (ttreeNodeArray == null) {
            return;
        }
        for (short s = 1; s < ttreeNodeArray.length; s = (short)(s + 1)) {
            if (ttreeNodeArray[s] == null) continue;
            short[] sArray2 = this.realloc2(sArray, s);
            System.out.print("[" + string + n + "]");
            this.outputItemSet(sArray2);
            System.out.println("= " + ttreeNodeArray[s].support);
            this.outputTtree(string + n, sArray2, ttreeNodeArray[s].childRef);
            ++n;
        }
    }

    public void outputTtree(JTextArea jTextArea) {
        int n = 1;
        jTextArea.append("T-TREE:\n-------\n");
        jTextArea.append("Format: [N] {I} = S, where N is the node number, I is the item set and S the support.\n");
        if (this.startTtreeRef == null) {
            jTextArea.append("Ttree empty!\n--------------------------------");
            return;
        }
        for (short s = 1; s < this.startTtreeRef.length; s = (short)((short)(s + 1))) {
            if (this.startTtreeRef[s] == null) continue;
            short[] sArray = new short[]{s};
            jTextArea.append("[" + n + "]");
            this.outputItemSet(jTextArea, sArray);
            jTextArea.append("= " + this.startTtreeRef[s].support + "\n");
            this.outputTtree(jTextArea, new Integer(n).toString(), sArray, this.startTtreeRef[s].childRef);
            ++n;
        }
        jTextArea.append("------------------------------------\n");
    }

    private void outputTtree(JTextArea jTextArea, String string, short[] sArray, TtreeNode[] ttreeNodeArray) {
        int n = 1;
        string = string + ".";
        if (ttreeNodeArray == null) {
            return;
        }
        for (short s = 1; s < ttreeNodeArray.length; s = (short)(s + 1)) {
            if (ttreeNodeArray[s] == null) continue;
            short[] sArray2 = this.realloc2(sArray, s);
            jTextArea.append("[" + string + n + "]");
            this.outputItemSet(jTextArea, sArray2);
            jTextArea.append("= " + ttreeNodeArray[s].support + "\n");
            this.outputTtree(jTextArea, string + n, sArray2, ttreeNodeArray[s].childRef);
            ++n;
        }
    }

    public void outputTtreeBranch(TtreeNode[] ttreeNodeArray) {
        int n = 1;
        if (ttreeNodeArray == null) {
            return;
        }
        for (short s = 1; s < ttreeNodeArray.length; s = (short)((short)(s + 1))) {
            if (ttreeNodeArray[s] == null) continue;
            short[] sArray = new short[]{s};
            System.out.print("[" + n + "]");
            this.outputItemSet(sArray);
            System.out.println("= " + ttreeNodeArray[s].support);
            this.outputTtree(new Integer(n).toString(), sArray, ttreeNodeArray[s].childRef);
            ++n;
        }
    }

    public void outputFrequentSets() {
        int n = 1;
        System.out.println("FREQUENT (LARGE) ITEM SETS:\n---------------------------");
        System.out.println("Format: [N] {I} = S, where N is a sequential number, I is the item set and S the support.");
        for (short s = 1; s <= this.numOneItemSets; s = (short)((short)(s + 1))) {
            if (this.startTtreeRef[s] == null || !((double)this.startTtreeRef[s].support >= this.minSupport)) continue;
            short[] sArray = new short[]{s};
            System.out.print("[" + n + "]");
            this.outputItemSet(sArray);
            System.out.println("= " + this.startTtreeRef[s].support);
            n = this.outputFrequentSets(n + 1, sArray, s, this.startTtreeRef[s].childRef);
        }
        System.out.println("\n");
    }

    private int outputFrequentSets(int n, short[] sArray, int n2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return n;
        }
        for (short s = 1; s < n2; s = (short)((short)(s + 1))) {
            if (ttreeNodeArray[s] == null || !((double)ttreeNodeArray[s].support >= this.minSupport)) continue;
            short[] sArray2 = this.realloc2(sArray, s);
            System.out.print("[" + n + "]");
            this.outputItemSet(sArray2);
            System.out.println("= " + ttreeNodeArray[s].support);
            n = this.outputFrequentSets(n + 1, sArray2, s, ttreeNodeArray[s].childRef);
        }
        return n;
    }

    public void outputFrequentSets(JTextArea jTextArea) {
        int n = 1;
        jTextArea.append("Format: [N] {I} = S, where N is a sequential number, I is the item set and S the support.\n");
        for (short s = 1; s <= this.numOneItemSets; s = (short)((short)(s + 1))) {
            if (this.startTtreeRef[s] == null || !((double)this.startTtreeRef[s].support >= this.minSupport)) continue;
            short[] sArray = new short[]{s};
            jTextArea.append("[" + n + "]");
            this.outputItemSet(jTextArea, sArray);
            jTextArea.append("= " + this.startTtreeRef[s].support + "\n");
            n = this.outputFrequentSets(jTextArea, n + 1, sArray, s, this.startTtreeRef[s].childRef);
        }
        System.out.println("\n");
    }

    private int outputFrequentSets(JTextArea jTextArea, int n, short[] sArray, int n2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return n;
        }
        for (short s = 1; s < n2; s = (short)((short)(s + 1))) {
            if (ttreeNodeArray[s] == null || !((double)ttreeNodeArray[s].support >= this.minSupport)) continue;
            short[] sArray2 = this.realloc2(sArray, s);
            jTextArea.append("[" + n + "]");
            this.outputItemSet(jTextArea, sArray2);
            jTextArea.append("= " + ttreeNodeArray[s].support + "\n");
            n = this.outputFrequentSets(jTextArea, n + 1, sArray2, s, ttreeNodeArray[s].childRef);
        }
        return n;
    }

    public void outputFrequentSetsSchema(JTextArea jTextArea) {
        int n = 1;
        jTextArea.append("Format: [N] {I} = S, where N is a sequential number, I is the item set and S the support.\n");
        for (short s = 1; s <= this.numOneItemSets; s = (short)((short)(s + 1))) {
            if (this.startTtreeRef[s] == null || !((double)this.startTtreeRef[s].support >= this.minSupport)) continue;
            short[] sArray = new short[]{s};
            jTextArea.append("[" + n + "]");
            this.outputItemSetSchema(jTextArea, sArray);
            jTextArea.append("= " + this.startTtreeRef[s].support + "\n");
            n = this.outputFrequentSetsSchema(jTextArea, n + 1, sArray, s, this.startTtreeRef[s].childRef);
        }
        System.out.println("\n");
    }

    private int outputFrequentSetsSchema(JTextArea jTextArea, int n, short[] sArray, int n2, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return n;
        }
        for (short s = 1; s < n2; s = (short)((short)(s + 1))) {
            if (ttreeNodeArray[s] == null || !((double)ttreeNodeArray[s].support >= this.minSupport)) continue;
            short[] sArray2 = this.realloc2(sArray, s);
            jTextArea.append("[" + n + "]");
            this.outputItemSetSchema(jTextArea, sArray2);
            jTextArea.append("= " + ttreeNodeArray[s].support + "\n");
            n = this.outputFrequentSetsSchema(jTextArea, n + 1, sArray2, s, ttreeNodeArray[s].childRef);
        }
        return n;
    }

    public void outputNumFreqSets() {
        if (this.startTtreeRef == null) {
            System.out.println("Number of frequent sets = 0");
        } else {
            System.out.println("Number of frequent sets = " + this.numFrequentSets);
        }
    }

    public void outputTtreeStats() {
        System.out.println("T-TREE STATISTICS (ARM)\n-----------------");
        System.out.println(this.numLevelsInTtree + " Levels in T-tree");
        System.out.println(TtreeNode.getNumberOfNodes() + " Total # nodes created");
        System.out.println(this.numUpdates + " Total # support value increments");
        System.out.println(this.numFrequentSets + " # Frequent sets");
        System.out.println(this.calculateStorage() + " Total storage (Bytes) on completion");
        System.out.println("-----------------------------------");
    }

    public void outputTtreeStats(JTextArea jTextArea) {
        jTextArea.append("T-TREE STATISTICS (ARM)\n-----------------\n");
        jTextArea.append(this.numLevelsInTtree + " Levels in T-tree\n");
        jTextArea.append(TtreeNode.getNumberOfNodes() + " Total # nodes created\n");
        jTextArea.append(this.numUpdates + " Total # support value increments\n");
        jTextArea.append(this.numFrequentSets + " Frequent sets\n");
        jTextArea.append(this.calculateStorage() + " Total storage (Bytes) on completion\n");
        jTextArea.append("-----------------------------------\n");
    }

    public void outputNumUpdates() {
        System.out.println("Number of T-tree nodes created = " + TtreeNode.getNumberOfNodes());
        System.out.println("Number of T-tree Updates       = " + this.numUpdates);
    }

    public void outputStorage() {
        if (this.startTtreeRef == null) {
            return;
        }
        System.out.println("T-tree Storage          = " + this.calculateStorage() + " (Bytes)");
    }

    protected int calculateStorage() {
        if (this.startTtreeRef == null) {
            return 0;
        }
        int n = 4;
        for (int i = 1; i <= this.numOneItemSets; ++i) {
            if (this.startTtreeRef[i] != null) {
                n = n + 12 + this.calculateStorage(0, this.startTtreeRef[i].childRef);
                continue;
            }
            n += 4;
        }
        return n;
    }

    private int calculateStorage(int n, TtreeNode[] ttreeNodeArray) {
        if (ttreeNodeArray == null) {
            return 0;
        }
        for (int i = 1; i < ttreeNodeArray.length; ++i) {
            if (ttreeNodeArray[i] != null) {
                n = n + 12 + this.calculateStorage(0, ttreeNodeArray[i].childRef);
                continue;
            }
            n += 4;
        }
        return n + 4;
    }

    @Override
    public void outputDuration(JTextArea jTextArea, double d, double d2) {
        double d3 = (d2 - d) / 1000.0;
        jTextArea.append("Generation time = " + this.twoDecPlaces(d3) + " seconds (" + this.twoDecPlaces(d3 / 60.0) + " mins)\n");
    }

    protected void outputSerializationArray() {
        for (int i = 0; i < this.serializationArray.length; i += 4) {
            System.out.println("(" + i + ") {" + this.serializationArray[i] + "} = " + this.serializationArray[i + 1] + ", " + this.serializationArray[i + 2] + ", " + this.serializationArray[i + 3]);
        }
    }

    protected void outputSerializedTtree() {
        int n = 1;
        int n2 = 0;
        while (n2 != -1) {
            String string = new Integer(this.serializationArray[n2]).toString();
            System.out.println("[" + n + "] {" + string + "} = " + this.serializationArray[n2 + 1]);
            this.outputSerializedTtree(new Integer(n).toString(), string, this.serializationArray[n2 + 2]);
            ++n;
            n2 = this.serializationArray[n2 + 3];
        }
    }

    protected void outputSerializedTtree(String string, String string2, int n) {
        int n2 = 1;
        string = string + ".";
        string2 = string2 + " ";
        if (n == -1) {
            return;
        }
        while (n != -1) {
            String string3 = new Integer(this.serializationArray[n]).toString();
            System.out.println("[" + string + n2 + "] {" + string2 + string3 + "} = " + this.serializationArray[n + 1]);
            String string4 = string2 + string3;
            this.outputSerializedTtree(string + n2, string4, this.serializationArray[n + 2]);
            ++n2;
            n = this.serializationArray[n + 3];
        }
    }

    protected void outputSerializedTtreeNoSupValues() {
        int n = 1;
        int n2 = 0;
        while (n2 != -1) {
            String string = new Integer(this.serializationArray[n2]).toString();
            System.out.println("[" + n + "] {" + string + "}");
            this.outputSerializedTtreeNoSupValues(new Integer(n).toString(), string, this.serializationArray[n2 + 1]);
            ++n;
            n2 = this.serializationArray[n2 + 2];
        }
    }

    private void outputSerializedTtreeNoSupValues(String string, String string2, int n) {
        int n2 = 1;
        string = string + ".";
        string2 = string2 + " ";
        if (n == -1) {
            return;
        }
        while (n != -1) {
            String string3 = new Integer(this.serializationArray[n]).toString();
            System.out.println("[" + string + n2 + "] {" + string2 + string3 + "}");
            String string4 = string2 + string3;
            this.outputSerializedTtreeNoSupValues(string + n2, string4, this.serializationArray[n + 1]);
            ++n2;
            n = this.serializationArray[n + 2];
        }
    }

    protected void outputSerializedTtreeLevelN(int n) {
        int n2 = 0;
        int n3 = 1;
        while (n2 < this.serializationArray.length) {
            int n4;
            System.out.print("[" + n3 + "] { ");
            for (n4 = 0; n4 < n; ++n4) {
                System.out.print(this.serializationArray[n2 + n4] + " ");
            }
            System.out.println("} = " + this.serializationArray[n2 + n4]);
            n2 = n2 + n + 1;
            ++n3;
        }
    }
}

