% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record-output.R
\name{record_output}
\alias{record_output}
\title{Record output of an R script and return it as a character vector}
\usage{
record_output(
  script,
  echo = FALSE,
  prompt = echo,
  stdout = TRUE,
  stderr = TRUE,
  ...
)
}
\arguments{
\item{script}{The code to record, passed to \code{\link[=record]{record()}}.}

\item{echo}{Whether to include the input in the return value.}

\item{prompt}{Whether to include the R prompt in the return value.}

\item{stdout}{Whether to include the standard output in the return
value.}

\item{stderr}{Whether to include the standard error in the return
value.}

\item{...}{Addiitonal arguments are passed to \code{\link[=record]{record()}}. (You cannot
use \code{typing_speed} and \code{echo}, though, because these are used
internally by \code{record_output()}.}
}
\value{
Character vector of output (plus input if \code{echo}, plus
prompt if \code{prompt}), as it would appear on a terminal.

See \code{\link[=record]{record()}} for additional options.
}
\description{
This function uses \code{\link[=record]{record()}} internally, but instead of creating
an ascii cast, it just returns the output of the code in a character
vector.
}
