% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-data-us.R, R/is-data-us.R
\name{assert_all_are_us_social_security_numbers}
\alias{assert_all_are_us_social_security_numbers}
\alias{assert_any_are_us_social_security_numbers}
\alias{is_us_social_security_number}
\title{Is the string a valid US SSN?}
\usage{
assert_all_are_us_social_security_numbers(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_us_social_security_numbers(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_us_social_security_number(x)
}
\arguments{
\item{x}{Input to check.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{is_us_social_security_number} returns \code{TRUE} if the input
string contains a valid US Social Security Number. The {assert_*} functions
return nothing but throw an error when the \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks that the input contains US Social Security Number.
}
\note{
A valid SSN is considered to be 3 digits, then 2 digits then 4 digits
possibly separated by a hyphen or space.  The first block cannot be 666 or a
begin with a nine, and no block can contain all zeroes.  The function
doesn't guarantee that the SSN actually exists.
}
\examples{
ssns <- c("123-45-6789", "666-45-6789", "123-00-6789")
is_us_social_security_number(ssns)
}

