% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-redux.R
\name{col_concat}
\alias{col_concat}
\title{Concatenate all columns of each row in data frame into a string}
\usage{
col_concat(data, sep = "")
}
\arguments{
\item{data}{A data frame}

\item{sep}{A string to separate the columns with (default: "")}
}
\value{
A vector of rows concatenated into strings
}
\description{
This function will return a vector, with the same length as the number
of rows of the provided data frame. Each element of the vector will be
it's corresponding row with all of its values (one for each column)
"pasted" together in a string.
}
\examples{

col_concat(mtcars)

library(magrittr)            # for piping operator

# you can use "assert_rows", "is_uniq", and this function to
# check if joint duplicates (across different columns) appear
# in a data frame
\dontrun{
mtcars \%>\%
  assert_rows(col_concat, is_uniq, mpg, hp)
  # fails because the first two rows are jointly duplicates
  # on these two columns
}

mtcars \%>\%
  assert_rows(col_concat, is_uniq, mpg, hp, wt) # ok

}
\seealso{
\code{\link{paste}}
}
