% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R, R/deprecated_se.R
\name{insist_rows}
\alias{insist_rows}
\alias{insist_rows_}
\title{Raises error if dynamically created predicate is FALSE for any row
after applying row reduction function}
\usage{
insist_rows(
  data,
  row_reduction_fn,
  predicate_generator,
  ...,
  success_fun = success_continue,
  error_fun = error_stop
)

insist_rows_(
  data,
  row_reduction_fn,
  predicate_generator,
  ...,
  .dots,
  success_fun = success_continue,
  error_fun = error_stop
)
}
\arguments{
\item{data}{A data frame}

\item{row_reduction_fn}{A function that returns a value for each row of
the provided data frame}

\item{predicate_generator}{A function that is applied to the results of
the row reduction function. This will produce,
a true predicate function to be applied to every
element in the vector that the row reduction
function returns.}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{success_fun}{Function to call if assertion passes. Defaults to
returning \code{data}.}

\item{error_fun}{Function to call if assertion fails. Defaults to printing
a summary of all errors.}

\item{.dots}{Use insist_rows_() to select columns using standard evaluation.}
}
\value{
By default, the \code{data} is returned if dynamically created
        predicate assertion is TRUE and and error is thrown if not. If a
        non-default \code{success_fun} or \code{error_fun} is used, the
        return values of these function will be returned.
}
\description{
Meant for use in a data analysis pipeline, this function applies a
function to a data frame that reduces each row to a single value. Then,
a predicate generating function is applied to row reduction values. It will
then use these predicates to check each of the row reduction values. If any
of these predicate applications yield FALSE, this function will raise
an error, effectively terminating the pipeline early. If there are no
FALSEs, this function will just return the data that it was supplied for
further use in later parts of the pipeline.
}
\details{
For examples of possible choices for the \code{success_fun} and
\code{error_fun} parameters, run \code{help("success_and_error_functions")}
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{

# returns mtcars
insist_rows(mtcars, maha_dist, within_n_mads(30), mpg:carb)

library(magrittr)                    # for piping operator

mtcars \%>\%
  insist_rows(maha_dist, within_n_mads(10), vs:am)
  # anything here will run

\dontrun{
mtcars \%>\%
  insist_rows(maha_dist, within_n_mads(1), everything())
  # the assertion is untrue so
  # nothing here will run}

}
\seealso{
\code{\link{insist}} \code{\link{assert_rows}}
         \code{\link{assert}} \code{\link{verify}}
}
