% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-get-match}
\alias{node-get-match}
\alias{node_get_match}
\alias{node_get_multiple_matches}
\title{Get the match(es) from a meta-variable}
\usage{
node_get_match(x, meta_var)

node_get_multiple_matches(x, meta_var)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}

\item{meta_var}{The name given to one of the meta-variable(s) in
\code{node_find()}.}
}
\value{
\code{node_get_match()} returns a list of depth 1, where each element is the node
corresponding to the \code{rule} passed (this can be of length 0 if no node is
matched).
\code{node_get_multiple_matches()} also returns a list of depth 1, but each
element can contain multiple nodes when the meta-variable captures all
elements in a pattern.
}
\description{
Those functions extract the content of the meta-variable specified in
\code{\link[=node_find]{node_find()}}:
\itemize{
\item \code{node_get_match()} is used when the meta-variable refers to a single
pattern, e.g. \verb{"plot($A)};
\item \code{node_get_multiple_matches()} is used when the meta-variable captures all
elements in a pattern, e.g. \code{"plot($$$A)"}.
}
}
\examples{
src <- "x <- rnorm(100, mean = 2)
    plot(mtcars)"

root <- src |>
  tree_new() |>
  tree_root()

# we capture a single element with "$A" so node_get_match() can be used
root |>
  node_find(ast_rule(pattern = "plot($A)")) |>
  node_get_match("A")

# we can specify the variable to extract
root |>
  node_find(ast_rule(pattern = "rnorm($A, $B)")) |>
  node_get_match("B")

# we capture many elements with "$$$A" so node_get_multiple_matches() can
# be used here
root |>
  node_find(ast_rule(pattern = "rnorm($$$A)")) |>
  node_get_multiple_matches("A")
}
