% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sideinfo_lib.R
\name{sureshrink.mse}
\alias{sureshrink.mse}
\title{SURE estimate of risk}
\usage{
sureshrink.mse(d, v.d, type = 1, t = 0)
}
\arguments{
\item{d}{an n vector of observations}

\item{v.d}{an n vector of variances for each component of d}

\item{type}{set type=1 if you want the thresholding parameter t to be estimated. Otherwise
set type = 0 in which case you must provide t. Default is type = 1}

\item{t}{soft thresholding parameter. If type = 1, then t is estimated whereas if type = 0
then you must provide t. Default is t = 0 (and type = 1)}
}
\value{
\enumerate{
\item sure.est - SURE estimate of risk
\item t - estimated threshold (meaningless if type = 0)
}
}
\description{
Stein's Unbiased Risk Estimate for the sureshrink estimator
}
\details{
Estimates the risk of the surehsrink estimator of Donoho and Johnstone (1995).
}
\examples{
library(asus)
set.seed(42)
d<-rnorm(10,2,1)
v.d<- rep(1,10)
mse<-sureshrink.mse(d,v.d)

}
\references{
\enumerate{
\item Charles M Stein. Estimation of the mean of a multivariate normal distribution. The annals of
Statistics, pages 1135-1151, 1981
\item David L Donoho and Iain M Johnstone. Adapting to unknown smoothness via wavelet shrinkage.
Journal of the american statistical association, 90(432):1200-1224, 1995
}
}
\seealso{
\code{\link{sureshrink}},\code{\link{asus}}
}
