% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-ids-fishbase.R
\name{get_ids_fishbase}
\alias{get_ids_fishbase}
\title{Extract fishbase IDs using the package "rfishbase" to generate species specific fishbase URLs}
\usage{
get_ids_fishbase(fish)
}
\arguments{
\item{fish}{Vector of fish species with genus and species information.}
}
\value{
named vector with species names and fishbase IDs.
}
\description{
This function extracts fishbase IDs using the database provided by the "rifishbase" package.
}
\details{
The function depends on the package "rfishbase" which creates a local copy of the fishbase database.
The IDs are needed to generate URLs to scan www.fishbase.se for detailed informations about fish growth for example.
}
\examples{
fish <- c("Gadus morhua", "Merlangius merlangus", "Clupea harengus")
get_ids_fishbase(fish)
}
\keyword{gen}
