% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_modelAudit.R
\name{plot.modelAudit}
\alias{plot.modelAudit}
\title{Model diagnostic plots}
\usage{
\method{plot}{modelAudit}(x, ..., type = "Residual", ask = TRUE)
}
\arguments{
\item{x}{object of class modelAudit}

\item{...}{other arguments dependent on the type of plot or additionl objects of class modelAudit}

\item{type}{the type of plot. Possible values: 'ACF', 'Autocorrelation', 'CumulativeGain', 'CooksDistance', 'HalfNormal', 'Residuals', 'LIFT',
ModelPCA', 'ModelRanking', ModelCorrelation', 'Prediction', 'REC', 'ResidualDensity', 'Residual', 'ROC', 'RROC',
ScaleLocation', 'TwoSidedECDF' (for detailed description see functions in see also section).}

\item{ask}{logical; if TRUE, the user is asked before each plot, see \code{\link[graphics]{par}(ask=)}.}
}
\description{
This function provides several diagnostic plots for regression and classification models.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plot(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plot(lm_au, rf_au, type = "ModelRanking")


}
\seealso{
\code{\link{plotACF}, \link{plotAutocorrelation}, \link{plotCumulativeGain}, \link{plotCooksDistance},
\link{plotHalfNormal}, \link{plotResidual}, \link{plotLIFT}, \link{plotModelPCA}, \link{plotModelRanking}, \link{plotModelCorrelation},
\link{plotPrediction}, \link{plotREC}, \link{plotResidualDensity}, \link{plotResidual}, \link{plotROC},
\link{plotRROC}, \link{plotScaleLocation}, \link{plotTwoSidedECDF}}
}
