% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.auditor_model_cooksdistance}
\alias{print.auditor_model_cooksdistance}
\title{Prints Model Cook's Distances Summary}
\usage{
\method{print}{auditor_model_cooksdistance}(x, ...)
}
\arguments{
\item{x}{an object 'auditor_model_cooksdistance' created with \code{\link{model_cooksdistance}} function.}

\item{...}{other parameters}
}
\description{
Prints Model Cook's Distances Summary
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# create an explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# calculate score
model_cooksdistance(exp_lm)

}
