% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals}
\alias{check_residuals}
\title{Automated tests for model residuals}
\usage{
check_residuals(object, ...)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{...}{other parameters that will be passed to further functions.}
}
\value{
list with statistics for particualar checks
}
\description{
Currently three tests are performed
 - for outliers in residuals
 - for autocorrelation in target variable or in residuals
 - for trend in residuals as a function of target variable (detection of bias)
}
\examples{
dragons <- DALEX::dragons[1:100, ]
lm_model <- lm(life_length ~ ., data = dragons)
lm_audit <- audit(lm_model, data = dragons, y = dragons$life_length)
check_residuals(lm_audit)
 \dontrun{
 library("randomForest")
 rf_model <- randomForest(life_length ~ ., data = dragons)
 rf_audit <- audit(rf_model, data = dragons, y = dragons$life_length)
 check_residuals(rf_audit)
}
}
