% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cooksdistance.R
\name{model_cooksdistance}
\alias{model_cooksdistance}
\alias{observationInfluence}
\title{Cook's distances}
\usage{
model_cooksdistance(object)

observationInfluence(object)
}
\arguments{
\item{object}{An object of class \code{explainer} created with function \code{\link[DALEX]{explain}} from the DALEX package.}
}
\value{
An object of the class \code{auditor_model_cooksdistance}.
}
\description{
Calculates Cook's distances for each observation.
Please, note that it will work only for functions with specified \code{update} method.
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

# use DALEX package to wrap up a model into explainer
glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
mc <- model_cooksdistance(glm_audit)
mc

plot(mc)

}
\references{
Cook, R. Dennis (1977). "Detection of Influential Observations in Linear Regression". doi:10.2307/1268249.
}
