% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residual.R
\name{plot_residual}
\alias{plot_residual}
\alias{plotResidual}
\title{Plot Residuals vs Observed, Fitted or Variable Values}
\usage{
plot_residual(
  object,
  ...,
  variable = "_y_",
  smooth = FALSE,
  std_residuals = FALSE,
  nlabel = 0
)

plotResidual(
  object,
  ...,
  variable = NULL,
  smooth = FALSE,
  std_residuals = FALSE,
  nlabel = 0
)
}
\arguments{
\item{object}{An object of class \code{auditor_model_residual} created with \code{\link{model_residual}} function.}

\item{...}{Other \code{auditor_model_residual} objects to be plotted together.}

\item{variable}{Name of variable to order residuals on a plot.
If \code{variable="_y_"}, the data is ordered by a vector of actual response (\code{y} parameter
passed to the \code{\link[DALEX]{explain}} function).
If \code{variable = "_y_hat_"} the data on the plot will be ordered by predicted response.
If \code{variable = NULL}, unordered observations are presented.}

\item{smooth}{Logical, indicates whenever smoothed lines should be added. By default it's \code{FALSE}.}

\item{std_residuals}{Logical, indicates whenever standardized residuals should be used.}

\item{nlabel}{Number of observations with the biggest absolute values of residuals to be labeled.}
}
\description{
A plot of residuals against fitted values, observed values or any variable.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

lm_audit <- audit(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
mr_lm <- model_residual(lm_audit)

# plot results
plot_residual(mr_lm)
plot(mr_lm, type = "residual")

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
rf_audit <- audit(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(rf_audit)
plot_residual(mr_lm, mr_rf)
plot(mr_rf, mr_rf, type = "residual")


}
