% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.r
\name{read_ebd}
\alias{read_ebd}
\alias{read_ebd.character}
\alias{read_ebd.auk_ebd}
\alias{read_sampling}
\alias{read_sampling.character}
\alias{read_sampling.auk_ebd}
\title{Read an EBD file}
\usage{
read_ebd(x, reader, sep, unique, setclass)

\method{read_ebd}{character}(x, reader, sep = "\\t", unique = TRUE,
  setclass = c("tbl", "data.frame", "data.table"))

\method{read_ebd}{auk_ebd}(x, reader, sep = "\\t", unique = TRUE,
  setclass = c("tbl", "data.frame", "data.table"))

read_sampling(x, reader, sep, unique, setclass)

\method{read_sampling}{character}(x, reader, sep = "\\t", unique = TRUE,
  setclass = c("tbl", "data.frame", "data.table"))

\method{read_sampling}{auk_ebd}(x, reader, sep = "\\t", unique = TRUE,
  setclass = c("tbl", "data.frame", "data.table"))
}
\arguments{
\item{x}{filename or \code{auk_ebd} object with associated output
files as created by \code{\link[=auk_filter]{auk_filter()}}.}

\item{reader}{character; the function to use for reading the input file,
options are \code{"fread"}, \code{"readr"}, or \code{"base"}, for \code{\link[data.table:fread]{data.table::fread()}},
\code{\link[readr:read_delim]{readr::read_delim()}}, or \link{read.delim}, respectively. This argument should
typically be left empty to have the function choose the best reader based
on the installed packages.}

\item{sep}{character; single character used to separate fields within a row.}

\item{unique}{logical; should duplicate grouped checklists be removed. If
\code{unique = TRUE}, \code{\link[=auk_unique]{auk_unique()}} is called on the EBD before returning.}

\item{setclass}{\code{tbl}, \code{data.frame}, or \code{data.table}; optionally set
additional classes to set on the output data. All return objects are
data frames, but may additionally be \code{tbl} (for use with \code{dplyr}
and the tidyverse) or \code{data.table} (for use with \code{data.table}). The default
is to return a tibble.}
}
\value{
A \code{data.frame} with additional class \code{tbl} unless \code{setclass} is used,
in which case a standard \code{data.frame} or \code{data.table} can be returned. An
additional column, \code{checklist_id}, is added to output files if
\code{unique = TRUE}, that uniquely identifies the checklist from which the
observation came. This field is equal to \code{sampling_event_identifier} for
non-group checklists, and \code{group_identifier} for group checklists.
}
\description{
Read an eBird Basic Dataset file using \code{\link[data.table:fread]{data.table::fread()}},
\code{\link[readr:read_delim]{readr::read_delim()}}, or \link{read.delim} depending on which packages are
installed. \code{read_ebd()} reads the EBD itself, while read_sampling()` reads a
sampling event data file.
}
\details{
This functions performs the following processing steps:
\itemize{
\item Data types for columns are manually set based on column names used in the
February 2017 EBD. If variables are added or names are changed in later
releases, any new variables will have data types inferred by the import
function used.
\item Variables names are converted to \code{snake_case}.
\item Duplicate observations resulting from group checklists are removed using
\code{\link[=auk_unique]{auk_unique()}}, unless \code{unique = FALSE}.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Filename of EBD.

\item \code{auk_ebd}: \code{auk_ebd} object output from \code{\link[=auk_filter]{auk_filter()}}

\item \code{character}: Filename of sampling event data file

\item \code{auk_ebd}: \code{auk_ebd} object output from \code{\link[=auk_filter]{auk_filter()}}. Must have
had a sampling event data file set in the original call to \code{\link[=auk_ebd]{auk_ebd()}}.
}}

\examples{
ebd <- system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  read_ebd()
# optionally return a plain data.frame
ebd_df <- system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  read_ebd(setclass = "data.frame")
# read a sampling event data file
x <- system.file("extdata/zerofill-ex_sampling.txt", package = "auk") \%>\%
  read_sampling()
}
