% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naiveBayes.R
\name{pfa.naiveBayes}
\alias{pfa.naiveBayes}
\title{PFA Formatting of Fitted naiveBayess}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{naiveBayes}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL, threshold = 0.001,
  eps = 0, pred_type = c("response", "prob"), cutoffs = NULL, ...)
}
\arguments{
\item{object}{an object of class "naiveBayes"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name 
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{threshold}{a value replacing cells with probabilities within eps range.}

\item{eps}{a numeric for specifying an epsilon-range to apply laplace 
smoothing (to replace zero or close-zero probabilities by theshold.)}

\item{pred_type}{a string with value "response" for returning the predicted class 
or the value "prob", which for returns the predicted probability of each class.}

\item{cutoffs}{A named numeric vector of length equal to 
number of classes. The "winning" class for an observation is the one with the 
maximum ratio of predicted probability to its cutoff. The default cutoffs assume the 
same cutoff for each class that is 1/k where k is the number of classes}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes a Naive Bayes model fit using naiveBayes()
and returns a list-of-lists representing in valid PFA document 
that could be used for scoring
}
\examples{
model <- e1071::naiveBayes(Species ~ ., data=iris) 
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[e1071]{naiveBayes}}
}
