% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{auth0_logout_url}
\alias{auth0_logout_url}
\title{Generate logout URL}
\usage{
auth0_logout_url(config_file = NULL, redirect_js = TRUE)
}
\arguments{
\item{config_file}{Path to YAML configuration file.}

\item{redirect_js}{include javascript code to redirect page? Defaults to \code{TRUE}.}
}
\value{
url string to logout, collapsed or not by javascript code.
}
\description{
Generates logout URL from configuration file. This can be used inside a
shiny app button to logout from the app.
}
\details{
To use this function successfully inside a shiny app, you may
want to install \code{shinyjs} package. See example

If you want to use a diferent configuration file you can set the \code{auth0_config_file}
option with: \code{options(auth0_config_file = "path/to-file")}.
}
\examples{
\donttest{
library(shiny)
library(auth0)
library(shinyjs)
# simple UI with action button
# note that you must include shinyjs::useShinyjs() for this to work
ui <- fluidPage(shinyjs::useShinyjs(), actionButton("logout_auth0", "Logout"))

# server with one observer that logouts
server <- function(input, output, session) {
  observeEvent(input$logout_auth0, {
    # javascript code redirecting to correct url
    js <- auth0_logout_url()
    shinyjs::runjs(js)
  })
}

shinyAuth0App(ui, server, config_file = config_file)
}

}
